import sandbox.common.types.task as ctt
from sandbox.sandboxsdk import errors
from sandbox import sdk2

from sandbox.projects.cloud.analytics.common.analytics_task \
    import AnalyticsTask


class CloudLeadsBillingUpdateIsvVar(AnalyticsTask):
    """ Task to import isv/var data from billing to DWH dyn table """

    class Parameters(AnalyticsTask.Parameters):
        yt_cluster = sdk2.parameters.String(
            'Destination YT cluster',
            default='hahn',
            required=True
        )
        yt_token_name = sdk2.parameters.String(
            'YT Token secret name',
            default='robot-clanalytics-yt-yt-token',
            required=True
        )
        threads_count = sdk2.parameters.Integer(
            'Threads Count',
            default=10,
            required=True
        )
        dyn_table_path = sdk2.parameters.String(
            'YT Path for Leads Dyn Table',
            default='//home/cloud_analytics/leads/dyn_table',
            required=True
        )
        ba_table_path = sdk2.parameters.String(
            'YT Path for Billing Tables',
            default='//home/cloud_analytics/import/billing/billing_accounts_isv_var',
            required=True
        )
        checkout_arcadia_from_url = sdk2.parameters.String(
            'Svn url for arcadia',
            default='arcadia:/arc/trunk/arcadia',
            required=True
        )
        program = sdk2.parameters.String(
            'Path to import script',
            default='cloud/analytics/scripts/import_ba_isv_var/import_ba_isv_var',
            required=True
        )

    def on_execute(self):
        with self.memoize_stage.create_children:
            task_class = sdk2.Task["YA_EXEC_FUSE"]
            sub_task = task_class(
                self,
                description='Child of task {}'.format(self.id),
                create_sub_task=False,
                checkout_arcadia_from_url=self.Parameters.checkout_arcadia_from_url,
                program=self.Parameters.program,
                program_args=' '.join([self.Parameters.ba_table_path, self.Parameters.dyn_table_path]),
                env_vars="YT_TOKEN_PATH='$(vault:file:{}:{})'".format(self.owner, self.Parameters.yt_token_name),
            )
            sub_task.Requirements.disk_space = self.Requirements.disk_space
            sub_task = sub_task.save().enqueue()
            raise sdk2.WaitTask(
                sub_task,
                (ctt.Status.Group.FINISH, ctt.Status.Group.BREAK)
            )

        child_tasks = self.find()
        for task in child_tasks:
            if task.status not in ctt.Status.Group.SUCCEED:
                raise errors.SandboxTaskFailureError('Child task is failed.')

