import time
from .session import IamAPISession


class IamAPI(object):
    ENDPOINT = 'https://identity.private-api.cloud.yandex.net:14336/v1'
    PAGE_SIZE = 1000

    def __init__(self, endpoint=ENDPOINT):
        self.endpoint = endpoint
        self.session = IamAPISession()

    def results_iterator(self, path, params, results_key, delay=0):
        ret = self.session.get(path, params=params).json()
        for result in ret[results_key]:
            yield result

        while 'nextPageToken' in ret:
            if delay > 0:
                time.sleep(delay)
            params['pageToken'] = ret['nextPageToken']
            ret = self.session.get(path, params=params).json()
            for result in ret[results_key]:
                yield result

    def clouds_creators(self, page_size=PAGE_SIZE, delay=0):
        return self.results_iterator(
            path=self.endpoint + '/clouds:creators',
            params={
                'pageSize': page_size,
                'showBlocked': '1'
            },
            results_key='cloudCreators',
            delay=delay
        )

    def cloud_folders(self, cloud_id):
        return self.results_iterator(
            path='%s/allFolders?cloudId=%s' % (self.endpoint, cloud_id),
            params={'pageSize': self.PAGE_SIZE},
            results_key='result'
        )
