import requests
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry


class IamAPISession(requests.Session):
    def __init__(self, connect=3, backoff_factor=0.5, status_forcelist=(500,), status=15, *args, **kwargs):
        super(IamAPISession, self).__init__(*args, **kwargs)
        retry = Retry(connect=connect, backoff_factor=backoff_factor, status_forcelist=status_forcelist, status=status)
        adapter = HTTPAdapter(max_retries=retry)
        self.mount('http://', adapter)
        self.mount('https://', adapter)

        self.headers.update({
            'User-Agent': 'https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/cloud/analytics/common/iam/client.py',
        })
