import requests
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry
from concurrent.futures import ThreadPoolExecutor
from requests_futures.sessions import FuturesSession


class BaseSolomonAPISession(requests.Session):
    def __init__(self, connect=3, backoff_factor=0.5, status_forcelist=(500, 503), status=15, *args, **kwargs):
        super(BaseSolomonAPISession, self).__init__(*args, **kwargs)
        retry = Retry(connect=connect, backoff_factor=backoff_factor, status_forcelist=status_forcelist, status=status)
        adapter = HTTPAdapter(max_retries=retry)
        self.mount('http://', adapter)
        self.mount('https://', adapter)

        self.headers.update({
            'User-Agent': 'https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/cloud/analytics/common/solomon/client.py',
        })


class SolomonAPISession(BaseSolomonAPISession):
    def init_oauth(self, token):
        self.headers.update({
            'Authorization': 'OAuth {token}'.format(token=token)
        })


class SolomonDataAPISession(BaseSolomonAPISession):
    pass


class SolomonDataAPIFuturesSession(FuturesSession):
    def __init__(self, executor=ThreadPoolExecutor(max_workers=20), *args, **kwargs):
        super(SolomonDataAPIFuturesSession, self).__init__(executor=executor,
                                 session=SolomonDataAPISession(), *args, **kwargs)
