import itertools
from datetime import datetime
from time import time

ISO_FORMAT = "%Y-%m-%dT%H:%M:%S"


def last_rounded_ts(interval):
    """

    :type interval: int
    """
    assert isinstance(interval, int)
    rounded_ts = (int(time()) // interval) * interval
    return datetime.utcfromtimestamp(rounded_ts)


def get_last_table(client, path):
    tables = client.list(path)
    if len(tables) > 0:
        tables.sort()
        return tables[-1]


def grouper_it(n, iterable):
    it = iter(iterable)
    while True:
        chunk_it = itertools.islice(it, n)
        try:
            first_el = next(chunk_it)
        except StopIteration:
            return
        yield itertools.chain((first_el,), chunk_it)


