import sandbox.common.types.task as ctt
from sandbox.sandboxsdk import errors
from sandbox import sdk2

from sandbox.projects.cloud.analytics.common.analytics_task \
    import AnalyticsTask


class CloudFormsLeadsToDynTable(AnalyticsTask):
    """ Task to import leads data from forms to DWH dyn table """

    class Parameters(AnalyticsTask.Parameters):
        yt_cluster = sdk2.parameters.String(
            'Destination YT cluster',
            default='hahn',
            required=True
        )
        yt_token_name = sdk2.parameters.String(
            'YT Token secret name',
            default='robot-clanalytics-yt-yt-token',
            required=True
        )
        dyn_table_path = sdk2.parameters.String(
            'YT Path for Leads Dyn Table',
            default='//home/cloud_analytics/leads/dyn_table',
            required=True
        )
        forms_tables_path_list = sdk2.parameters.List(
            'List of YT Path for forms tables',
            required=True
        )
        checkout_arcadia_from_url = sdk2.parameters.String(
            'Svn url for arcadia',
            default='arcadia:/arc/trunk/arcadia',
            required=True
        )
        program = sdk2.parameters.String(
            'Path to import script',
            default='cloud/analytics/scripts/import_forms_leads/import_forms_leads',
            required=True
        )

    def on_execute(self):
        for table_path in self.Parameters.forms_tables_path_list:
            self._wait_for_subtask(
                "run_import form {}".format(table_path),
                "YA_EXEC_FUSE",
                checkout_arcadia_from_url=self.Parameters.checkout_arcadia_from_url,
                program=self.Parameters.program,
                program_args=' '.join([table_path, self.Parameters.dyn_table_path]),
                env_vars="YT_TOKEN_PATH='$(vault:file:{}:{})'".format(self.owner, self.Parameters.yt_token_name),
            )

