from sandbox import sdk2
from sandbox.sdk2.vcs.svn import Arcadia

from sandbox.projects.cloud.analytics.common.analytics_task \
    import AnalyticsTask


class CloudIamLeadsToDynTable(AnalyticsTask):
    """ Task to import leads data from IAM to DWH dyn table """

    class Parameters(AnalyticsTask.Parameters):
        yql_file = sdk2.parameters.String(
            'Path to YQL file in arcadia',
            default='/arc/trunk/arcadia/cloud/analytics/yql/import_leads_to_dyn_table_updates.yql',
            required=True
        )
        yt_cluster = sdk2.parameters.String(
            'Destination YT cluster',
            default='hahn',
            required=True
        )
        yt_token_name = sdk2.parameters.String(
            'YT Token secret name',
            default='robot-clanalytics-yt-yt-token',
            required=True
        )
        dyn_table_path = sdk2.parameters.String(
            'YT Path for Leads Dyn Table',
            default='//home/cloud_analytics/leads/dyn_table',
            required=True
        )
        updates_tables_path = sdk2.parameters.String(
            'YT Path for updates tables',
            default='//home/cloud_analytics/leads/updates',
            required=True
        )
        checkout_arcadia_from_url = sdk2.parameters.String(
            'Svn url for arcadia',
            default='arcadia:/arc/trunk/arcadia',
            required=True
        )
        program = sdk2.parameters.String(
            'Path to import script',
            default='cloud/analytics/scripts/import_leads_data/import_leads_data',
            required=True
        )

    def on_execute(self):
        query = Arcadia.cat(
            ':'.join([Arcadia.ARCADIA_SCHEME, self.Parameters.yql_file])
        )

        self._wait_for_subtask(
            "run_yql",
            "RUN_YQL_2",
            query=query,
            trace_query=True,
            owner=self.Parameters.owner,
            publish_query=True,
            use_v1_syntax=True,
            custom_placeholders={
                '%UPDATES_TABLES_PATH%':
                    self.Parameters.updates_tables_path,
                '%YT_CLUSTER%': self.Parameters.yt_cluster
            }
        )

        self._wait_for_subtask(
            "run_import",
            "YA_EXEC_FUSE",
            checkout_arcadia_from_url=self.Parameters.checkout_arcadia_from_url,
            program=self.Parameters.program,
            program_args=' '.join([self.Parameters.updates_tables_path, self.Parameters.dyn_table_path]),
            env_vars="YT_TOKEN_PATH='$(vault:file:{}:{})'".format(self.owner, self.Parameters.yt_token_name),
        )

