from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.projects.common.juggler import jclient
from sandbox.sdk2.vcs.svn import Arcadia
from sandbox.projects.cloud.analytics.common.analytics_task import AnalyticsTask
import logging

class CloudRunYqlAlerts(AnalyticsTask):
    """ Task to run YQL query from file in arcadia """
    STATUSES = {
        True: 'OK',
        False: 'CRIT',
    }

    ALERTS_TABLE = '//home/cloud_analytics/tmp/alerts'

    class Parameters(AnalyticsTask.Parameters):
        yt_cluster = sdk2.parameters.String(
            'YT cluster',
            default='hahn',
            required=True
        )

        yt_token_name = sdk2.parameters.String(
            'YT Token secret name',
            default='robot-clanalytics-yt-yt-token',
            required=True
        )

        yql_file = sdk2.parameters.String(
            'Path to yql file',
            default='/arc/trunk/arcadia/cloud/analytics/yql/alerting.yql',
            required=True
        )

    class Requirements(AnalyticsTask.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
        )


    def send_event(self, flag, count):
        task_link = 'https://sandbox.yandex-team.ru/task/{}/view'.format(self.id)
        if not count:
            description = '{} is OK. {}'.format(flag, task_link)
        else:
            description = 'Problem with {}={}. {}'.format(flag, count, task_link)
        logging.debug("Push event {} to juggler with status {}".format(flag, self.STATUSES[not count]))
        jclient.send_events_to_juggler(
            'cloud-analytics-yql-alerts',
            flag,
            self.STATUSES[not count],
            description
        )

    def on_execute(self):
        import yt.wrapper as yt

        query = Arcadia.cat(':'.join([Arcadia.ARCADIA_SCHEME, self.Parameters.yql_file]))
        yt.config['token'] = sdk2.Vault.data(
            self.owner,
            self.Parameters.yt_token_name,
        )
        yt.config['proxy']['url'] = 'hahn'


        self._wait_for_subtask(
            "run_yql",
            "RUN_YQL_2",
            query=query,
            trace_query=True,
            owner=self.Parameters.owner,
            publish_query=True,
            use_v1_syntax=True,
            custom_placeholders={
                '%TMP_TABLE%': self.ALERTS_TABLE,
                '%YT_CLUSTER%': self.Parameters.yt_cluster
            }
        )

        for row in yt.read_table(self.ALERTS_TABLE):
            for k, v in row.items():
                self.send_event(k, v)
            break
