from sandbox import sdk2
from sandbox.sdk2.vcs.svn import Arcadia
from sandbox.projects.yql.RunYQL2 import RunYQL2
import sandbox.common.types.task as ctt
from sandbox.sandboxsdk import errors
from sandbox.projects.cloud.analytics.common.analytics_task import AnalyticsTask


class CloudRunYqlArcadia(AnalyticsTask):
    """ Task to run YQL query from file in arcadia """

    class Parameters(AnalyticsTask.Parameters):
        yql_file = sdk2.parameters.String(
            'Path to yql file',
            default='/arc/trunk/arcadia/cloud/analytics/yql/example.yql',
            required=True
        )
        custom_placeholders = sdk2.parameters.Dict(
            'Custom placeholders (keys like %KEY%)'
        )
        use_v1_syntax = sdk2.parameters.Bool(
            'Use SQLv1 syntax',
            default=False
        )
        use_clickhouse_syntax = sdk2.parameters.Bool(
            'Use clickhouse syntax',
            default=False
        )

    def on_execute(self):
        query = Arcadia.cat(':'.join([Arcadia.ARCADIA_SCHEME, self.Parameters.yql_file]))

        with self.memoize_stage.create_children:
            sub_task = RunYQL2(
                self,
                description='Child of task {}'.format(self.id),
                create_sub_task=False,
                query=query,
                trace_query=True,
                owner=self.Parameters.owner,
                publish_query=True,
                use_v1_syntax=self.Parameters.use_v1_syntax,
                use_clickhouse_syntax=self.Parameters.use_clickhouse_syntax,
                custom_placeholders=self.Parameters.custom_placeholders
            ).enqueue()

            raise sdk2.WaitTask(sub_task, (ctt.Status.Group.FINISH, ctt.Status.Group.BREAK))

        child_tasks = self.find()
        for task in child_tasks:
            if task.status not in ctt.Status.Group.SUCCEED:
                raise errors.SandboxTaskFailureError('Child task is failed.')
