from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.projects.cloud.analytics.common.analytics_task import AnalyticsTask


class CloudStToYT(AnalyticsTask):

    class Parameters(AnalyticsTask.Parameters):
        st_tasks_filter = sdk2.parameters.String(
            'Tasks Filter',
            default='filter=queue:CLOUDBIZ&filter=tags:promoevent&filter=components:47009',
            required=True
        )
        st_tasks_attributes = sdk2.parameters.List(
            'Tasks attributes to import',
            default=[
                'key',
                'summary',
                'resolvedAt'
            ],
            required=True
        )
        st_token_name = sdk2.parameters.String(
            'StarTrek Token secret name',
            default='ST_TOKEN',
            required=True
        )
        dst_yt_table_prefix = sdk2.parameters.String(
            'Prefix for destination table in YT',
            default='//home/cloud_analytics/import/startrek/promo_events',
            required=True
        )
        dst_yt_cluster = sdk2.parameters.String(
            'YT cluster for destination table',
            default='hahn',
            required=True
        )
        yt_token_name = sdk2.parameters.String(
            'YT Token secret name',
            default='YT_TOKEN',
            required=True
        )

    class Requirements(AnalyticsTask.Requirements):
        environments = (
            environments.PipEnvironment('requests'),
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet')
        )

    def on_execute(self):

        import requests
        import sys
        import yt.wrapper as yt

        reload(sys)
        sys.setdefaultencoding('utf8')

        def data_iterator(json_items, column_names):
            for st_task in json_items:
                yield {i: st_task[i] for i in column_names if i in st_task}

        st_url = 'https://st-api.yandex-team.ru/v2/issues?%s' \
                 % self.Parameters.st_tasks_filter
        r = requests.get(
            st_url,
            headers={
                'Authorization': 'OAuth %s' % sdk2.Vault.data(
                    self.owner, self.Parameters.st_token_name
                )
            }
        )

        yt.config['token'] = sdk2.Vault.data(
            self.owner,
            self.Parameters.yt_token_name
        )
        yt.config['proxy']['url'] = self.Parameters.dst_yt_cluster
        yt.write_table(
            self.Parameters.dst_yt_table_prefix,
            data_iterator(r.json(), self.Parameters.st_tasks_attributes)
        )
