from sandbox import sdk2
from sandbox.sdk2.vcs.svn import Arcadia

from sandbox.projects.cloud.analytics.common.analytics_task \
    import AnalyticsTask


class CloudUpdateLeadIdInDynTable(AnalyticsTask):
    """ Task to update info about marketo lead id to DWH dyn table """

    class Parameters(AnalyticsTask.Parameters):
        yql_file = sdk2.parameters.String(
            'Path to YQL file in arcadia',
            default='/arc/trunk/arcadia/cloud/analytics/yql/update_lead_id.yql',
            required=True
        )
        yt_cluster = sdk2.parameters.String(
            'Destination YT cluster',
            default='hahn',
            required=True
        )
        yt_token_name = sdk2.parameters.String(
            'YT Token secret name',
            default='robot-clanalytics-yt-yt-token',
            required=True
        )
        dyn_table_path = sdk2.parameters.String(
            'YT Path for Leads Dyn Table',
            default='//home/cloud_analytics/leads/dyn_table',
            required=True
        )
        tmp_table_path = sdk2.parameters.String(
            'YT Path for updates tables',
            default='//home/cloud_analytics/tmp/new_lead',
            required=True
        )
        checkout_arcadia_from_url = sdk2.parameters.String(
            'Svn url for arcadia',
            default='arcadia:/arc/trunk/arcadia',
            required=True
        )
        program = sdk2.parameters.String(
            'Path to import script',
            default='cloud/analytics/scripts/update_lead_id/update_lead_id',
            required=True
        )

    def on_execute(self):
        query = Arcadia.cat(
            ':'.join([Arcadia.ARCADIA_SCHEME, self.Parameters.yql_file])
        )

        self._wait_for_subtask(
            "run_yql",
            "RUN_YQL_2",
            query=query,
            trace_query=True,
            owner=self.Parameters.owner,
            publish_query=True,
            use_v1_syntax=True,
            custom_placeholders={
                '%TMP_TABLE_PATH%':
                    self.Parameters.tmp_table_path,
                '%YT_CLUSTER%': self.Parameters.yt_cluster
            }
        )

        self._wait_for_subtask(
            "run_import",
            "YA_EXEC_FUSE",
            checkout_arcadia_from_url=self.Parameters.checkout_arcadia_from_url,
            program=self.Parameters.program,
            program_args=' '.join([self.Parameters.tmp_table_path, self.Parameters.dyn_table_path]),
            env_vars="YT_TOKEN_PATH='$(vault:file:{}:{})'".format(self.owner, self.Parameters.yt_token_name),
        )

