from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.projects.cloud.analytics.common.analytics_task import AnalyticsTask


class CloudWikiToYT(AnalyticsTask):

    class Parameters(AnalyticsTask.Parameters):
        table_columns = sdk2.parameters.List(
            'Table Columns',
            default=[
                'crm_client_name',
                'billing_account_id',
                'sales',
                'segment'
            ],
            required=True
        )
        wiki_uri = sdk2.parameters.String(
            'URI to wiki page with table',
            default='cloud-bizdev/Enterprise-ISV-clients/Spisok-Ent/ISV/',
            required=True
        )
        wiki_token_name = sdk2.parameters.String(
            'WIKI Token secret name',
            default='WIKI_TOKEN',
            required=True
        )
        dst_yt_table_prefix = sdk2.parameters.String(
            'Prefix for destination table in YT',
            default='//home/cloud_analytics/import/wiki/clients_segments',
            required=True
        )
        dst_yt_cluster = sdk2.parameters.String(
            'YT cluster for destination table',
            default='hahn',
            required=True
        )
        yt_token_name = sdk2.parameters.String(
            'YT Token secret name',
            default='YT_TOKEN',
            required=True
        )

    class Requirements(AnalyticsTask.Requirements):
        environments = (
            environments.PipEnvironment('requests'),
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet')
        )

    def on_execute(self):

        import requests
        import sys
        import yt.wrapper as yt

        reload(sys)
        sys.setdefaultencoding('utf8')

        def data_iterator(json_items, column_names):
            items = [[c['raw'] for c in row]
                     for row in json_items['data']['rows']]
            for item in items:
                yield {k: v for k, v in zip(column_names, item)}

        wiki_url = 'https://wiki-api.yandex-team.ru/_api/frontend/%s/.grid' \
                   % self.Parameters.wiki_uri
        r = requests.get(
            wiki_url,
            headers={
                'Authorization': 'OAuth %s' % sdk2.Vault.data(
                    self.owner, self.Parameters.wiki_token_name
                )
            }
        )

        yt.config['token'] = sdk2.Vault.data(
            self.owner,
            self.Parameters.yt_token_name
        )
        yt.config['proxy']['url'] = self.Parameters.dst_yt_cluster
        yt.write_table(
            self.Parameters.dst_yt_table_prefix,
            data_iterator(r.json(), self.Parameters.table_columns)
        )
