from sandbox import sdk2
from sandbox.sdk2.vcs.svn import Arcadia

from sandbox.projects.cloud.analytics.common.analytics_task \
    import AnalyticsTask


class CloudYaFillOutFOrm(AnalyticsTask):
    """ Task to prepare fillout forms activity data for importing to marketo  """

    class Parameters(AnalyticsTask.Parameters):
        yql_file = sdk2.parameters.String(
            'Path to YQL file in arcadia',
            default='/arc/trunk/arcadia/cloud/analytics/yql/ya_fill_out_form.yql',
            required=True
        )
        yt_cluster = sdk2.parameters.String(
            'Destination YT cluster',
            default='hahn',
            required=True
        )
        yt_token_name = sdk2.parameters.String(
            'YT Token secret name',
            default='robot-clanalytics-yt-yt-token',
            required=True
        )
        forms_tables_path_list = sdk2.parameters.List(
            'List of YT Path for forms tables',
            required=True
        )

    def on_execute(self):
        query = Arcadia.cat(
            ':'.join([Arcadia.ARCADIA_SCHEME, self.Parameters.yql_file])
        )

        self._wait_for_subtask(
            "run_yql",
            "RUN_YQL_2",
            query=query,
            trace_query=True,
            owner=self.Parameters.owner,
            publish_query=True,
            use_v1_syntax=True,
            custom_placeholders={
                '%FORMS_TABLES%':
                    ', '.join(['"{}"'.format(t) for t in self.Parameters.forms_tables_path_list]),
                '%YT_CLUSTER%': self.Parameters.yt_cluster
            }
        )

