from sandbox.sandboxsdk import environments

from sandbox import sdk2
from sandbox.projects.cloud.billing.common.task import SmallTask


class AggregateBillingExportTable(SmallTask):
    """ Task to aggregate exported billing tables """

    class Parameters(SmallTask.Parameters):
        yt_cluster = sdk2.parameters.String(
            'Destination YT cluster',
            default='hahn',
            required=True
        )
        yql_token_name = sdk2.parameters.String(
            'YQL Token secret name',
            required=True
        )
        src_dir_path = sdk2.parameters.String(
            'YT Path for source directory',
            required=True
        )
        dst_table_path = sdk2.parameters.String(
            'YT Path for destination table',
            required=True
        )
        tmp_dir_path = sdk2.parameters.String(
            'YT Path for tmp directory',
            required=False
        )
        export_time_field = sdk2.parameters.String(
            'Export time field',
            required=True
        )
        primary_key_fields = sdk2.parameters.String(
            'Primary key fields, separated by comma',
            required=True
        )
        other_fields = sdk2.parameters.String(
            'Other fields, separated by comma',
            required=True
        )

    class Requirements(SmallTask.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
            environments.PipEnvironment('yql')
        )

    def on_execute(self):
        from yql.api.v1.client import YqlClient
        import yt.wrapper as ytw
        from cloud.billing.utils.scripts.aggregate_billing_export_table import aggregate_billing_export_table
        yql_token = sdk2.Vault.data(self.owner, self.Parameters.yql_token_name)
        yt_proxy = self.Parameters.yt_cluster
        dst_table_path = self.Parameters.dst_table_path
        src_dir_path = self.Parameters.src_dir_path
        export_time_field = self.Parameters.export_time_field
        primary_key_fields = self.Parameters.primary_key_fields.split(',')
        other_fields = self.Parameters.other_fields.split(',')
        yql_client = YqlClient(db=yt_proxy, token=yql_token)

        ytw.config['token'] = yql_token
        ytw.config['proxy']['url'] = yt_proxy

        aggregate_billing_export_table(
            src_dir_path=src_dir_path,
            dst_table_path=dst_table_path,
            primary_key_fields=primary_key_fields,
            other_fields=other_fields,
            export_time_field=export_time_field,
            yql_client=yql_client,
            yt_wrapper=ytw,
            tmp_dir=self.Parameters.tmp_dir_path
        )
