from sandbox import sdk2
from sandbox.projects.cloud.billing.common.task import SmallTask
from sandbox.sandboxsdk import environments


class AggregateRevenueReports(SmallTask):
    """ Task to aggregate revenue reports """

    class Parameters(SmallTask.Parameters):
        yt_cluster = sdk2.parameters.String(
            'Destination YT cluster',
            default='hahn',
            required=True
        )
        yql_token_name = sdk2.parameters.String(
            'YQL Token secret name',
            required=True
        )
        src_dir_path = sdk2.parameters.String(
            'YT Path for source directory',
            required=True
        )
        dst_dir_path = sdk2.parameters.String(
            'YT Path for destination directory',
            required=True
        )

    class Requirements(SmallTask.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
            environments.PipEnvironment('yql')
        )

    def on_execute(self):
        from cloud.billing.utils.scripts.aggregate_revenue_reports import aggregate_revenue_reports
        from yql.api.v1.client import YqlClient
        import yt.wrapper as ytw
        yql_token = sdk2.Vault.data(self.owner, self.Parameters.yql_token_name)
        yt_proxy = self.Parameters.yt_cluster
        dst_dir_path = self.Parameters.dst_dir_path
        src_dir_path = self.Parameters.src_dir_path

        yql_client = YqlClient(db=yt_proxy, token=yql_token)

        ytw.config['token'] = yql_token
        ytw.config['proxy']['url'] = yt_proxy

        aggregate_revenue_reports(
            src_dir_path=src_dir_path,
            dst_dir_path=dst_dir_path,
            yql_client=yql_client,
            yt_wrapper=ytw
        )
