from sandbox import sdk2
from sandbox.projects.cloud.billing.common.task import AutoBinaryTask
from sandbox.sandboxsdk import environments


def checkout_dir(path, revision):
    dir_name = path[path.rfind('/') + 1:]
    sdk2.svn.Arcadia.checkout(
        url="svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/" + path,
        path=dir_name,
        revision=revision,
    )
    return dir_name


def read_file_from_dir(dir_name, file_name):
    f = open(dir_name + '/' + file_name)
    query = f.read()
    f.close()
    return query


class ApplyQueryToTable(AutoBinaryTask):
    """ Task to apply YQL-query to table"""

    class Parameters(AutoBinaryTask.Parameters):
        yt_cluster = sdk2.parameters.String(
            'Destination YT cluster',
            default='hahn',
            required=True
        )
        yql_token_name = sdk2.parameters.String(
            'YQL Token secret name',
            required=True
        )
        directory_path = sdk2.parameters.String(
            'Path from /arcadia to directory with query and table_paths.',
            required=True
        )
        table_paths_file_name = sdk2.parameters.String(
            'File name with table paths. Should not contain "$src_dir" and "$dst_dir',
            required=True
        )
        query_file_name = sdk2.parameters.String(
            'File name with query. Query must contain variable "$result". You can use variable "$src_table"',
            required=True
        )
        outputs = sdk2.parameters.String(
            '"QUERY_VAR1:TABLE_PATH1,QUERY_VAR2:TABLE_PATH2..." - which variables where insert to',
            default="result://home/cloud/billing/..."
        )
        outputs_primary_keys = sdk2.parameters.Dict(
            'Outputs primary keys',
            description='result:key1,key2',
        )
        arcadia_revision = sdk2.parameters.String(
            'Arcadia revision number',
            required=True
        )

    class Requirements(AutoBinaryTask.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
            environments.PipEnvironment('yql')
        )

    def on_execute(self):
        from yql.api.v1.client import YqlClient
        import yt.wrapper as ytw
        from cloud.billing.utils.scripts.apply_query_to_table import apply_query_to_table
        yql_token = sdk2.Vault.data(self.owner, self.Parameters.yql_token_name)
        yt_proxy = self.Parameters.yt_cluster
        outputs = self.Parameters.outputs
        outputs_primary_keys = self.Parameters.outputs_primary_keys
        yql_client = YqlClient(db=yt_proxy, token=yql_token)

        dir_path = self.Parameters.directory_path
        table_paths_file_name = self.Parameters.table_paths_file_name
        query_file_name = self.Parameters.query_file_name
        arcadia_revision = self.Parameters.arcadia_revision

        dir_name = checkout_dir(dir_path, arcadia_revision)

        table_list = read_file_from_dir(dir_name, table_paths_file_name)
        query = read_file_from_dir(dir_name, query_file_name)

        ytw.config['token'] = yql_token
        ytw.config['proxy']['url'] = yt_proxy
        apply_query_to_table(
            yql_client=yql_client,
            yt_wrapper=ytw,
            query=table_list + '\n' + query,
            outputs=outputs,
            outputs_primary_keys=outputs_primary_keys,
        )
