from sandbox import sdk2


class CheckQueryResultIsEmptyParams(sdk2.Parameters):
    with sdk2.parameters.Group('Check. {check_label}') as g:
        is_enabled = sdk2.parameters.Bool('Enabled')
        with is_enabled.value[True]:
            juggler_host_for_result = sdk2.parameters.String(
                'Host Name in Juggler for result monitoring',
                default='',
                required=False
            )
            juggler_service_name_for_result = sdk2.parameters.String(
                'Service name in Juggler for result monitoring',
                default='',
                required=False
            )
            query_kwargs = sdk2.parameters.String(
                'Query kwargs',
                description='kwarg1:value1,kwarg2:value2,...'
            )
            arcadia_query_path = sdk2.parameters.String(
                'Svn url to file with query.',
                required=False
            )
            arcadia_revision = sdk2.parameters.String(
                'Arcadia revision number',
                required=True
            )
            raise_on_error = sdk2.parameters.Bool(
                'Raise if result not empty',
                description='Raise error if result is not empty. Otherwise only send notification',
                default=True,
            )
