from sandbox import sdk2


def get_name(name, prefix=None, suffix=None):
    if prefix is not None:
        name = ''.join([prefix, '_', name])
    if suffix is not None:
        name = ''.join([name, '_', suffix])

    return name


def get_parameters_group_values(task, prefix):
    """
    Get values from parameters group

    :param task: task
    :type task: sdk2.Task
    :param prefix: prefix
    :type prefix: str
    :return: dictionary with param_name:value
    :rtype: dict
    """

    group_name = get_name('is_enabled', prefix=prefix)
    if getattr(task.Parameters, group_name) is None:
        raise ValueError('No group with name {}'.format(group_name))

    params = {}
    for param_name in getattr(task.type.Parameters, group_name).sub_fields.get('true', []):
        param_prefix = prefix + "_"

        if param_name.startswith(param_prefix):
            sanitized_name = param_name[len(param_prefix):]
            params[sanitized_name] = getattr(task.Parameters, param_name)

    return params
