from sandbox import sdk2
from sandbox.projects.cloud.billing.common.task import SmallTask
from sandbox.projects.common import binary_task
from sandbox.sandboxsdk import environments


class CalculateAnalyticsCubeTotalSum(binary_task.LastBinaryTaskRelease, SmallTask):
    """ Task to calculate analytics cube total """

    class Parameters(SmallTask.Parameters):
        yt_cluster = sdk2.parameters.String(
            'Destination YT cluster',
            default='hahn',
            required=True
        )
        yql_token_name = sdk2.parameters.String(
            'YQL Token secret name',
            required=True
        )
        src_table_path = sdk2.parameters.String(
            'YT Path for source directory',
            required=True
        )
        dst_table_path = sdk2.parameters.String(
            'YT Path for destination directory',
            required=True
        )
        start_date = sdk2.parameters.String(
            "Start date to calc sum from",
            default="1970-01-01"
        )
        ext_params = binary_task.binary_release_parameters(stable=True)

    class Requirements(SmallTask.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
            environments.PipEnvironment('yql')
        )

    def on_execute(self):
        from cloud.billing.utils.scripts.calculate_analytics_cube_total_sum import calculate_analytics_cube_total_sum
        from yql.api.v1.client import YqlClient
        import yt.wrapper as ytw
        yql_token = sdk2.Vault.data(self.owner, self.Parameters.yql_token_name)
        yt_proxy = self.Parameters.yt_cluster
        src_table_path = self.Parameters.src_table_path
        dst_table_path = self.Parameters.dst_table_path
        start_date = self.Parameters.start_date

        yql_client = YqlClient(db=yt_proxy, token=yql_token)

        ytw.config['token'] = yql_token
        ytw.config['proxy']['url'] = yt_proxy
        calculate_analytics_cube_total_sum(
            src_table_path=src_table_path,
            dst_table_path=dst_table_path,
            yql_client=yql_client,
            yt_wrapper=ytw,
            start_date=start_date
        )
