from sandbox import sdk2
from sandbox.projects.cloud.billing.common.task import SmallTask
from sandbox.sandboxsdk import environments


class EnrichSalesNameTable(SmallTask):
    class Parameters(SmallTask.Parameters):
        yt_cluster = sdk2.parameters.String(
            'Destination YT cluster',
            default='hahn',
            required=True
        )
        yt_token_name = sdk2.parameters.String(
            'YT Token secret name',
            required=True
        )
        staff_oauth_token_name = sdk2.parameters.String(
            'STAFF API Oauth Token secret name',
            required=True
        )
        staff_url = sdk2.parameters.String(
            'STAFF API Url',
            required=True
        )
        src_table_path = sdk2.parameters.String(
            'YT Path for source table',
            required=True
        )
        dst_table_path = sdk2.parameters.String(
            'YT Path for destination table',
            required=True
        )

    class Requirements(SmallTask.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
            environments.PipEnvironment('yql'),
            environments.PipEnvironment('requests')
        )

    def on_execute(self):
        from cloud.billing.utils.scripts.enrich_sales_name_table import enrich_sales_name_table
        staff_token = sdk2.Vault.data(self.owner, self.Parameters.staff_oauth_token_name)
        staff_url = self.Parameters.staff_url
        yt_token = sdk2.Vault.data(self.owner, self.Parameters.yt_token_name)
        yt_proxy = self.Parameters.yt_cluster
        src_table_path = self.Parameters.src_table_path
        dst_table_path = self.Parameters.dst_table_path
        enrich_sales_name_table(
            src_table_path=src_table_path,
            dst_table_path=dst_table_path,
            staff_token=staff_token,
            staff_url=staff_url,
            yt_proxy=yt_proxy,
            yt_token=yt_token
        )
