from sandbox import sdk2
from sandbox.projects.cloud.billing.common.task import SmallTask
from sandbox.sandboxsdk import environments


class FindDuplicateMetrics(SmallTask):
    """ Task to find duplicates in metrics from services """

    class Parameters(SmallTask.Parameters):
        juggler_host_for_result = sdk2.parameters.String(
            'Host Name in Juggler for result monitoring',
            default='',
            required=True
        )
        juggler_service_name_for_result = sdk2.parameters.String(
            'Service name in Juggler for result monitoring',
            default='',
            required=True
        )
        yt_cluster = sdk2.parameters.String(
            'Destination YT cluster',
            default='hahn',
            required=True
        )
        yql_token_name = sdk2.parameters.String(
            'YQL Token secret name',
            required=True
        )
        src_dir_path = sdk2.parameters.String(
            'YT Path for source directory',
            required=True
        )
        since_date = sdk2.parameters.String(
            'Format: YYYY-MM-DD. Find duplicate metrics since this date. If empty - last 2 days.',
            required=False
        )

    class Requirements(SmallTask.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
            environments.PipEnvironment('yql')
        )

    def on_execute(self):
        from cloud.billing.utils.scripts.find_duplicate_metrics import find_duplicate_metrics
        from yql.api.v1.client import YqlClient
        import yt.wrapper as ytw
        yql_token = sdk2.Vault.data(self.owner, self.Parameters.yql_token_name)
        yt_proxy = self.Parameters.yt_cluster
        src_dir_path = self.Parameters.src_dir_path

        yql_client = YqlClient(db=yt_proxy, token=yql_token)

        ytw.config['token'] = yql_token
        ytw.config['proxy']['url'] = yt_proxy
        result, share_url = find_duplicate_metrics(
            src_dir_path=src_dir_path,
            yql_client=yql_client,
            yt_wrapper=ytw,
            since_date=self.Parameters.since_date
        )
        description = "{} duplicates found. Operation: {}".format(len(result), share_url)
        if len(result) == 0:
            self.send_event_to_juggler('OK', self.Parameters.juggler_host_for_result,
                                       self.Parameters.juggler_service_name_for_result, description)
        else:
            self.send_event_to_juggler('CRIT', self.Parameters.juggler_host_for_result,
                                       self.Parameters.juggler_service_name_for_result, description)
