from sandbox import sdk2
from sandbox.projects.cloud.billing.common.task import SmallTask
from sandbox.sandboxsdk import environments


class RankMarketplaceProducts(SmallTask):
    class Parameters(SmallTask.Parameters):
        yt_cluster = sdk2.parameters.String(
            'Destination YT cluster',
            default='hahn',
            required=True
        )
        yql_token_name = sdk2.parameters.String(
            'YQL Token secret name',
            required=True
        )
        src_metrics_dir = sdk2.parameters.String(
            'YT Path for source metrics directory',
            required=True
        )
        dst_table = sdk2.parameters.String(
            'YT Path for destination directory',
            required=True
        )
        days_limit = sdk2.parameters.Integer(
            'How many day-tables to look at? By default - all tables',
            required=False
        )

    class Requirements(SmallTask.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
            environments.PipEnvironment('yql')
        )

    def on_execute(self):
        from cloud.billing.utils.scripts.rank_marketplace_products import rank_marketplace_products
        from yql.api.v1.client import YqlClient
        yql_token = sdk2.Vault.data(self.owner, self.Parameters.yql_token_name)
        yt_proxy = self.Parameters.yt_cluster
        src_metrics_dir = self.Parameters.src_metrics_dir
        dst_table = self.Parameters.dst_table
        days_limit = self.Parameters.days_limit
        yql_client = YqlClient(db=yt_proxy, token=yql_token)

        rank_marketplace_products(
            src_metrics_dir=src_metrics_dir,
            dst_table=dst_table,
            yql_client=yql_client,
            days_limit=days_limit
        )
