from sandbox import sdk2
from sandbox.projects.cloud.billing.common.task import SmallTask
from sandbox.sandboxsdk import environments


class TableFromYtToS3(SmallTask):
    """ Task to send table from yt to s3 bucket """

    class Parameters(SmallTask.Parameters):
        yt_cluster = sdk2.parameters.String(
            'Destination YT cluster',
            default='hahn',
            required=True
        )
        yt_token_name = sdk2.parameters.String(
            'YT Token secret name',
            required=True
        )
        src_table_path = sdk2.parameters.String(
            'YT Path for source Table',
            required=True
        )
        s3_endpoint_url = sdk2.parameters.String(
            'S3 URL',
            required=True
        )
        access_key_id = sdk2.parameters.String(
            'Vault name with access key id to s3 bucket',
            required=True
        )
        secret_access_key = sdk2.parameters.String(
            'Vault name with secret access key to s3 bucket',
            required=True
        )
        bucket_name = sdk2.parameters.String(
            'S3 bucket name',
            required=True
        )

    class Requirements(SmallTask.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
            environments.PipEnvironment('boto3')
        )

    def on_execute(self):
        from cloud.billing.utils.scripts.table_from_yt_to_s3 import table_from_yt_to_s3

        yt_token = sdk2.Vault.data(self.owner, self.Parameters.yt_token_name)
        yt_proxy = self.Parameters.yt_cluster

        src_table_path = self.Parameters.src_table_path
        aws_access_key_id = sdk2.Vault.data(self.owner, self.Parameters.access_key_id)
        aws_secret_access_key = sdk2.Vault.data(self.owner, self.Parameters.secret_access_key)
        s3_endpoint_url = self.Parameters.s3_endpoint_url
        bucket_name = self.Parameters.bucket_name
        table_from_yt_to_s3(
            yt_proxy=yt_proxy,
            yt_token=yt_token,
            src_table_path=src_table_path,
            access_key_id=aws_access_key_id,
            secret_access_key=aws_secret_access_key,
            s3_endpoint_url=s3_endpoint_url,
            bucket_name=bucket_name
        )
