import sandbox.common.types.client as ctc
import sandbox.common.types.misc as ctm

from sandbox import sdk2
from sandbox.projects.common import binary_task


class NbsBinaryTask(binary_task.LastBinaryTaskRelease, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        _ = binary_task.LastBinaryReleaseParameters()


class NbsLightTask:

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        ram = 1024
        disk_space = 30 * 1024
        dns = ctm.DnsType.DNS64
        client_tags = ctc.Tag.Group.LINUX

        class Caches(sdk2.Requirements.Caches):
            pass
