import logging

from sandbox import sdk2
from sandbox.projects.cloud.blockstore.shared import NbsBinaryTask, NbsLightTask


class NbsAnalyzeUsedGroup(NbsBinaryTask):
    class Requirements(NbsLightTask.Requirements):
        cores = 32
        ram = 20 * 1024
        pass

    class Parameters(NbsBinaryTask.Parameters):
        # common parameters
        max_restarts = 1
        kill_timeout = 3600

        thread_count = 32
        core_resource = sdk2.parameters.String(
            "Resource id of core tool")
        ydb_url = sdk2.parameters.String(
            "URL path to YDB",
            default="ydb-ru-prestable.yandex.net:2135")
        ydb_database = sdk2.parameters.String(
            "Database name in YDB",
            default="/ru-prestable/nbs/test/volumestats/")
        ydb_table = sdk2.parameters.String(
            "Table name in database",
            required=True)
        ydb_oauth = sdk2.parameters.Vault(
            "YDB OAuth",
            required=True,
            default="YC_NBS:robot-yc-nbs-ydb-token")

    def on_save(self):
        super(NbsAnalyzeUsedGroup, self).on_save()

    def on_execute(self):
        super(NbsAnalyzeUsedGroup, self).on_execute()

        from cloud.blockstore.sandbox.tasks.NbsAnalyzeUsedGroup import Task
        Task(self, logger=logging.getLogger('task')).run()
