import logging

from sandbox import sdk2
from sandbox.projects.cloud.blockstore.shared import NbsBinaryTask, NbsLightTask


class NbsAnalyzeYtLogs(NbsBinaryTask):
    class Requirements(NbsLightTask.Requirements):
        pass

    class Parameters(NbsBinaryTask.Parameters):
        # common parameters
        max_restarts = 1
        kill_timeout = 3600

        yt_oauth = sdk2.parameters.Vault(
            "YT OAuth",
            required=True,
            default="YC_NBS:robot-yc-nbs-yt-oauth")
        yt_pool = sdk2.parameters.String(
            "YT Pool",
            default="cloud-nbs")

    def on_save(self):
        # binary task magic
        super(NbsAnalyzeYtLogs, self).on_save()

    def on_execute(self):
        # binary task magic
        super(NbsAnalyzeYtLogs, self).on_execute()

        from cloud.blockstore.sandbox.tasks.NbsAnalyzeYtLogs import Task
        Task(self, logger=logging.getLogger('task')).run()
