from sandbox import sdk2
from sandbox.common.types import notification as ctn
from sandbox.common.types import task as ctt
from sandbox.projects.cloud.blockstore.shared import (
    NbsBinaryTask,
    NbsLightTask,
)


class NbsTeamcityRunner(NbsBinaryTask):
    class Requirements(NbsLightTask.Requirements):
        pass

    class Parameters(NbsBinaryTask.Parameters):
        description = 'Default nbs teamcity runner description'
        notifications = [
            sdk2.Notification(
                [
                    ctt.Status.EXCEPTION,
                    ctt.Status.TIMEOUT,
                ],
                [
                    'vlad-serikov@yandex-team.ru',
                ],
                ctn.Transport.EMAIL,
            ),
        ]

        with sdk2.parameters.Group('VCS parameters') as vcsp:
            branch = sdk2.parameters.String(
                'Branch',
                default='trunk',
            )
            commit = sdk2.parameters.String(
                'Commit',
                default='',
            )
            arc_token = sdk2.parameters.YavSecret(
                'Arc token',
                default_value='{}#{}'.format(
                    'sec-01ekjvt2kbg4ag64z9z03jt0hp',
                    'arc.token',
                )
            )

        with sdk2.parameters.Group('Teamcity plugin parameters') as tsp:
            teamcity_build_id = sdk2.parameters.String(
                'Teamcity build id',
                default='',
            )

        with sdk2.parameters.Group('Config parameters') as cp:
            root_path = sdk2.parameters.String(
                'Config root path from repository root',
                default='',
            )
            config_path = sdk2.parameters.String(
                'Config path from repository root',
                default='',
            )

    def on_save(self):
        # binary task magic
        super(NbsTeamcityRunner, self).on_save()

    def on_prepare(self):
        from cloud.blockstore.sandbox.tasks.NbsTeamcityRunner import Task
        self.__task = Task(self)
        self.__task.on_prepare()

    def on_execute(self):
        # binary task magic
        super(NbsTeamcityRunner, self).on_execute()
        self.__task.on_execute()

    def on_before_timeout(self, seconds):
        self.__task.on_before_timeout(seconds)

    def on_terminate(self):
        self.__task.on_terminate()
