from sandbox import sdk2
from sandbox.common.types import notification as ctn
from sandbox.common.types import task as ctt
from sandbox.projects import resource_types
from sandbox.projects.cloud.blockstore.shared import (
    NbsBinaryTask,
    NbsLightTask,
)


class NbsTeamcityTest(NbsBinaryTask):
    class Requirements(NbsLightTask.Requirements):
        pass

    class Parameters(NbsBinaryTask.Parameters):
        description = 'Default nbs teamcity test description'
        notifications = [
            sdk2.Notification(
                [
                    ctt.Status.EXCEPTION,
                    ctt.Status.TIMEOUT,
                ],
                [
                    'vlad-serikov@yandex-team.ru',
                ],
                ctn.Transport.EMAIL,
            ),
        ]

        with sdk2.parameters.Group('Test parameters') as tp:
            test_binaries = sdk2.parameters.Resource(
                'Resource with test binaries',
                resource_type=resource_types.ARCADIA_PROJECT,
                required=True,
            )

            cmd = sdk2.parameters.String(
                'List with cmd lines to execute',
                required=True,
            )

            use_ycp = sdk2.parameters.Bool(
                'Use ycp',
                default_value=False,
            )
            with use_ycp.value['True']:
                ycp_config_path = sdk2.parameters.String(
                    'Path to config for ycp',
                    default_value='/usr/bin/config/ycp/config.yaml',
                )

            use_custom_ssh = sdk2.parameters.Bool(
                'Use custom ssh settings',
                default_value=False,
            )
            with use_custom_ssh.value['True']:
                ssh_config_path = sdk2.parameters.String(
                    'Path to ssh config',
                    default_value='/usr/bin/config/ssh/config',
                )

        with sdk2.parameters.Group('Retry parameters') as rp:
            sandbox_restarts = sdk2.parameters.Integer(
                'How many times task can be restarted after sandbox node failure (do not work with "no_retry" policy)',
                default=0,
            )
            with sdk2.parameters.RadioGroup('Retrying policy') as retry_policy:
                retry_policy.values['no_retry'] = retry_policy.Value(
                    'No retry on error',
                    default=True,
                )
                retry_policy.values['line'] = retry_policy.Value(
                    'Retry current line on error or node shutdown',
                )
                retry_policy.values['complete'] = retry_policy.Value(
                    'Retry script from the begining on error or node shutdown',
                )
            with retry_policy.value['line']:
                retry_line_count = sdk2.parameters.Integer(
                    'Retry count (won\'t increase on node shutdown)',
                    default=0,
                )
            with retry_policy.value['complete']:
                retry_complete_count = sdk2.parameters.Integer(
                    'Retry count (won\'t increase on node shutdown)',
                    default=0,
                )

        with sdk2.parameters.Group('Access parameters') as ap:
            ssh_key = sdk2.parameters.YavSecret(
                'Ssh key to connect to created VMs',
                default_value='{}#{}'.format(
                    'sec-01g6n81wt8wc6ph8kagb5b33bf',
                    'ssh-overlay-private-key',
                )
            )
            yt_oauth_token = sdk2.parameters.YavSecret(
                'YT oauth token',
                default_value='{}#{}'.format(
                    'sec-01dhvc807c509927fzgnb84b20',
                    'robot-yc-nbs-yt-oauth',
                )
            )

    def on_save(self):
        # binary task magic
        super(NbsTeamcityTest, self).on_save()

    def on_prepare(self):
        from cloud.blockstore.sandbox.tasks.NbsTeamcityTest import Task
        self.__task = Task(self)
        self.__task.on_prepare()

    def on_execute(self):
        # binary task magic
        super(NbsTeamcityTest, self).on_execute()
        self.__task.on_execute()

    def on_before_timeout(self, seconds):
        self.__task.on_before_timeout(seconds)

    def on_terminate(self):
        self.__task.on_terminate()
