# -*- coding: utf-8 -*-

import requests
import json
from sandbox import sdk2
from sandbox.sdk2 import yav


class ChecklistsParser(sdk2.Task):
    def get_secrets(self):
        secret = yav.Secret("sec-01dvx104f3y3515tmxc6wx3f53")

        self.db_password = secret.data().get("db_password", None)
        if self.db_password is None:
            raise Exception("Problem with DB password!")

        oauth_token = secret.data().get("token", None)
        if oauth_token is not None:
            self.headers = {}
            self.headers["Authorization"] = "OAuth {}".format(oauth_token)
        else:
            raise Exception("Problem with token!")

    def db_push(self, checklist_dict):
        import psycopg2

        SQL_CONNECTION_PARAMS = (
            "host=c-mdbl1if2iee71tvvbnq8.rw.db.yandex.net\n"
            "port=6432\n"
            "dbname=checkdb\n"
            "user=robot\n"
            "password={}\n"
            "target_session_attrs=read-write"
        )
        SQL_QUERY_PREPARE = (
            "PREPARE push (text, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, "
            "bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, "
            "bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, bool, "
            "bool, bool, bool) AS INSERT INTO checklists VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, "
            "$14, $15, $16, $17, $18, $19, $20, $21, $22, $23, $24, $25, $26, $27, $28, $29, $30, $31, $32, $33, $34, $35, "
            "$36, $37, $38, $39, $40, $41, $42, $43, $44, $45, $46, $47, $48, $49, $50, $51, $52, $53, $54, $55) ON CONFLICT "
            '(checklist) DO UPDATE SET checklist = $1, "1" = $2, "2" = $3, "3" = $4, "4" = $5, "5" = $6, "6" = $7, "7" = $8, '
            '"8" = $9, "9" = $10, "10" = $11, "11" = $12, "12" = $13, "13" = $14, "14" = $15, "15" = $16, "16" = $17, '
            '"17" = $18, "18" = $19, "19" = $20, "20" = $21, "21" = $22, "22" = $23, "23" = $24, "24" = $25, "25" = $26, '
            '"26" = $27, "27" = $28, "28" = $29, "29" = $30, "30" = $31, "31" = $32, "32" = $33, "33" = $34, "34" = $35, '
            '"35" = $36, "36" = $37, "37" = $38, "38" = $39, "39" = $40, "40" = $41, "41" = $42, "42" = $43, "43" = $44, '
            '"44" = $45, "45" = $46, "46" = $47, "47" = $48, "48" = $49, "49" = $50, "50" = $51, "51" = $52, "52" = $53, '
            '"53" = $54, "54" = $55; '
            "EXECUTE push ('{}', {});"
        )

        connection = psycopg2.connect(SQL_CONNECTION_PARAMS.format(self.db_password))
        connection.autocommit = True

        cursor = connection.cursor()

        for key, value in checklist_dict.items():
            cursor.execute(
                SQL_QUERY_PREPARE.format(key, ", ".join([str(item) for item in value.values()]),)
            )

        cursor.close()

    def get_checklists_set(self):
        response = requests.get(
            url="https://wiki-api.yandex-team.ru/_api/frontend/cloud/security/compliance/processes/new-compliance-check/.tree",
            headers=self.headers,
        )
        data = json.loads(response.content)

        checklists_set = [
            page["page"]["cluster"]
            for page in data["data"]["subpages"]
            if page["page"]["cluster"][-16:] == "compliance-check"
        ]

        return checklists_set

    def get_checklist(self, checklist):
        response = requests.get(
            url="https://wiki-api.yandex-team.ru/_api/frontend/cloud/security/compliance/processes/new-compliance-check/{}/.grid".format(
                checklist
            ),
            headers=self.headers,
        )

        data = json.loads(response.content)
        if len(data["data"]["rows"]) == 54 and len(data["data"]["structure"]["fields"]) == 6:
            rows = [row[4]["raw"] for row in data["data"]["rows"]]
            rows_dict = dict(zip(list(range(1, 55)), rows))

            return {data["data"]["structure"]["title"]: rows_dict}

    def on_execute(self):
        self.get_secrets()
        checklists_set = self.get_checklists_set()
        checklist_dict = dict()
        [
            checklist_dict.update(self.get_checklist(checklist))
            for checklist in checklists_set
            if self.get_checklist(checklist) is not None
        ]
        self.db_push(checklist_dict)
