# -*- coding: utf-8 -*-


class ProdConfig:
    ABC_URL = "https://abc-back.yandex-team.ru/api/v4/services/members/"
    STAFF_URL = "https://staff-api.yandex-team.ru/v3/persons/"
    STAFF_GROUPS_URL = "https://staff-api.yandex-team.ru/v3/groupmembership"

    SECRET_ID = "sec-01dvx104f3y3515tmxc6wx3f53"

    CONNECTED_GROUPS_URLS = {
        # 'yandex_fin_internalaudit_8312',  # Отдел ИТ Аудита
        # 'yandex_legal_supp',  # Группа правового соправождения сервисов
        # 'yandex_legal_control_economic_9828',
        # Группа правового соправождения инфраструктурных проектов
        # 'yandex_proffice_support_search_24h',  # Группа круглосуточного мониторинга
        # 'yandex_edu_prec_staff',  # Служба по работе со штатными сотрудниками
        # 'yandex_edu_personel_rec_first',
        #  Служба подбора персонала для главного бизнес-юнита и инфраструктуры
        "yandex_mnt_infra_itdc_2250",  # Группа второй линии поддержки
        "yandex_mnt_1500_3591_9478_dep79314",  # Подгруппа ремонта и диагностики оборудования
        "yandex_mnt_infra_itdc",  # Служба IT инфраструктуры датацентров
        "yandex_mnt_infra_itdc_dep94275",  # Группа IT поддержки ДЦ Мытищи
        "yandex_mnt_dc_engineer_myt",  # Группа эксплуатации ДЦ «Мытищи»
        "yandex_mnt_1500_3591_9478",  # Группа складской логистики ДЦ "Мытищи"
        "yandex_mnt_infra_itdc_dep25048",  # Группа IT поддержки ДЦ Сасово
        "yandex_mnt_dc_engineer_sas",  # Группа эксплуатации ДЦ «Сасово»
        "yandex_mnt_1500_3591_dep62918_dep07504",  # Группа складской логистики ДЦ "Сасово"
        "yandex_mnt_infra_itdc_dep92487",  # Группа IT поддержки ДЦ Владимир
        "yandex_mnt_dc_vlad",  # Группа эксплуатации ДЦ «Владимир»
        "yandex_mnt_1500_3591_dep62918_dep10316"  # Группа складской логистики ДЦ "Владимир"
        "yandex_mnt_phys_eng",  # Инженерная группа
        "yandex_mnt_planning_cable",  # Группа структурированных кабельных систем
        "ext_dep64485_dep06083",  # Стройтехзащита - ACVS-5765
    }
    ABC_BLACK_LIST = {
        2282,  # Яндекс.Облако CRM
        31665,  # Yandex.Cloud CRM - access
        2306,  # Yandex.Cloud CRM - prod
        2602,  # Yandex.Cloud CRM - testing
        3092,  # YC Docs Review
        1989,  # YC Docs
        3339,  # TT SLB
        33509,  # DataSphere для Яндекса
    }

    ITDC_COURSE_LIST = [
        "Группа IT поддержки ДЦ Мытищи",
        "Группа эксплуатации ДЦ «Мытищи»",
        "Группа IT поддержки ДЦ Сасово",
        "Группа эксплуатации ДЦ «Сасово»",
        "Группа IT поддержки ДЦ Владимир",
        "Группа эксплуатации ДЦ «Владимир»",
    ]

    TVM_ID_MOE = "2001279"
    TVM_ID_MOE_TEST = "2001097"
    TVM_ID_ML = "2014406"
    TVM_ID_CLOUD = "2018276"

    SQL_QUERY_GET = (
        "SELECT login, name, iso_relation, docs_signed, docs_signing_ticket, "
        "last_update, staff_department, location, added, position, devel_subscribed, "
        "leads_subscribed, course_15_all_result, course_15_all_date, course_15_tech_result, "
        "course_15_tech_date, course_184_result, course_184_date, course_317_result, course_317_date, "
        "course_464_result, course_464_date, uid, aw_ticket, courses_ticket, encryption_status, "
        "av_status, role_check, fw_status, services, st_docs_signed, course_1010_result, course_1010_date, course_1010_ticket, role_ticket FROM clouds_employees_inventory"
    )
    SQL_QUERY_PREPARE = (
        "PREPARE push (text, text, text, boolean, text, date, text, text, "
        "date, text, boolean, boolean, numeric, text, numeric, text, "
        "numeric, text, numeric, text, numeric, text, numeric, text, text, json, json, text, json, text, boolean, numeric, text, text, text) AS INSERT INTO "
        "clouds_employees_inventory "
        "VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18, "
        "$19, $20, $21, $22, $23, $24, $25, $26, $27, $28, $29, $30, $31, $32, $33, $34, $35) ON CONFLICT (login) DO UPDATE SET name=$1, login=$2, iso_relation=$3, "
        "docs_signed=$4, docs_signing_ticket=$5, last_update=$6, staff_department=$7, location=$8, "
        "added = $9, position=$10, devel_subscribed=$11, leads_subscribed=$12, "
        "course_15_all_result=$13, course_15_all_date=$14, course_15_tech_result=$15, "
        "course_15_tech_date=$16, course_184_result=$17, course_184_date=$18, course_317_result=$19, "
        "course_317_date=$20, course_464_result=$21, course_464_date=$22, uid=$23, aw_ticket=$24, "
        "courses_ticket=$25, encryption_status=$26, av_status=$27, role_check=$28, fw_status=$29, services=$30, st_docs_signed=$31, "
        "course_1010_result=$32, course_1010_date=$33, course_1010_ticket=$34, role_ticket=$35;"
        "EXECUTE push('{0}','{1}','{2}','{3}','{4}','{5}','{6}','{7}','{8}','{9}','{10}','{11}',"
        "{12},'{13}',{14},'{15}',{16},'{17}',{18},'{19}',{20},'{21}',{22},'{23}','{24}','{25}','{26}','{27}','{28}', '{29}', '{30}', '{31}', '{32}','{33}','{34}');"
    )

    SQL_CONNECTION_PARAMS = (
        "host=c-mdbl1if2iee71tvvbnq8.rw.db.yandex.net\n"
        "port=6432\n"
        "dbname=checkdb\n"
        "user=robot\n"
        "password={}\n"
        "target_session_attrs=read-write"
    )

    TASK_TEXT = (
        "Коллеги, привет. \nДля соответствия внутренним процессам обеспечения информационной безопасности в Яндекс.Облаке, все "
        "сотрудники должны под роспись ознакомиться со следующими документами:\n* Политика ИБ "
        "Яндекс.Облака;\n* Политика ИБ Яндекса;\n* Положение об обработке ПД Яндекс.Облака;\n* Политика использования "
        "приватных данных пользователей Yandex. \n\nПо нашим данным, сотрудники ниже данные документы "
        "не подписали.\nВ связи с этим, необходимо пригласить их в HR для подписи за ознакомления с "
        "указанными выше документами.\nПеречень сотрудников:\n{}\n\nP.S. Данный тикет сгенерирован "
        "автоматически. В случае, если вы обнаружите какую то ошибку, просьба написать об этом на "
        "рассылку cloud-compliance@yandex-team.ru"
    )
    TASK_QUEUE = "HR"
    TASK_SUMMARY = "Новые сотрудники Облака"
    TASK_FOLLOWERS = [
        {"id": "semen-tarasov"},
        {"id": "yrovenskiy"},
    ]
    TASK_ASSIGNE = {"id": "ksenia-im"}

    ENCR_TASK_QUEUE = "CLOUD"
    ENCR_TASK_SUMMARY = "Шифрование ПК"
    ENCR_TASK_TEXT = (
        "Привет. \n Мы обнаружили что твой ПК {} (серийный номер {}) не зашифрован.\n"
        "В связи с требования ИБ, действующими в Облаке, все ПК у сотрудников должны быть зашифрованы.\n\n"
        "Зашифруй, пожалуйста, указанный выше компьютер. Процесс описан в "
        "((https://wiki.yandex-team.ru/cloud/compliance/iso-checklist/#proveritchtovkljuchenoshifrovaniediska инструкции)). "
        "\n\nP.S. Данный тикет сгенерирован "
        "автоматически. В случае, если вы обнаружите какую то ошибку, просьба написать об этом на "
        "рассылку cloud-compliance@yandex-team.ru"
    )
    ENCR_TASK_FOLLOWERS = [
        {"id": "semen-tarasov"},
        {"id": "yrovenskiy"},
    ]
    ENCR_TASK_TAGS = ["compliance_encryption"]

    AV_TASK_QUEUE = "CLOUD"
    AV_TASK_SUMMARY = "Антивирус"
    AV_TASK_TEXT = (
        "Привет. \n Мы обнаружили что на твоем ПК {} не работает антивирус.\n"
        "В связи с требования ИБ, действующими в Облаке, на всех ПК у сотрудников должны функционировать антивирусы.\n\n"
        "Установи/запусти, пожалуйста, антивирус на указанном выше компьютере. Процесс описан в "
        "((https://wiki.yandex-team.ru/cloud/compliance/iso-checklist/#nastroitrabochujustanciju инструкции)). "
        "\n\nP.S. Данный тикет сгенерирован "
        "автоматически. В случае, если вы обнаружите какую то ошибку, просьба написать об этом на "
        "рассылку cloud-compliance@yandex-team.ru"
    )
    AV_TASK_FOLLOWERS = [
        {"id": "semen-tarasov"},
        {"id": "yrovenskiy"},
    ]
    AV_TASK_TAGS = ["compliance_av"]

    ROLE_TASK_QUEUE = "CLOUD"
    ROLE_TASK_SUMMARY = "Роль на staff"
    ROLE_TASK_TEXT = (
        "Привет. \n Мы обнаружили что на твоей странице на staff указана роль, не описанная в наших ((https://wiki.yandex-team.ru/cloud/regulations/roles-duties/ должностных обязанностях)).\n"
        "В связи с требования ИБ, действующими в Облаке, у всех сотрудников должна быть роль, описанная в этом документе.\n\n"
        "Пожалуйста, укажи на staff роль, описанную в документе и подходящую тебе по обязаностям. Подробнее процесс описан в "
        "((https://wiki.yandex-team.ru/cloud/compliance/iso-checklist/#proveritrol инструкции)). "
        "\n\nP.S. Данный тикет сгенерирован "
        "автоматически. В случае, если вы обнаружите какую то ошибку, просьба написать об этом на "
        "рассылку cloud-compliance@yandex-team.ru"
    )
    ROLE_TASK_FOLLOWERS = [
        {"id": "semen-tarasov"},
        {"id": "yrovenskiy"},
    ]
    ROLE_TASK_TAGS = ["compliance_role"]

    AWARENESS_TASK_QUEUE = "CLOUD"
    AWARENESS_TASK_SUMMARY = "Awareness"
    AWARENESS_TASK_TEXT = (
        "Привет!\n"
        "Мы обнаружили, что у тебя есть роль в одном из Облачных сервисов. \n"
        "В Облаке действуют повышенные требования к информационной безопасности, в том числе к сотрудникам. \n"
        "Полный перечень необходимых действий, которые необходимо выполнить всем сотрудника для соответствия "
        "требованиям, описан на вики в виде ((https://wiki.yandex-team.ru/cloud/compliance/iso-checklist/ "
        "чеклиста)).\n"
        "Для вашего же удобства, вы можете помечать шаги которые выполнили в нижеприведенном чеклисте.\n\n"
        "По всем вопросам можешь смело писать в телеграм-чат ((https://t.me/joinchat/D98VvhRohkGmig3iRM7FFQ "
        "телеграм-чат YC Compliance)) или на рассылку mailto:cloud-compliance@yandex-team.ru.\n\n"
        "P.S. Данный тикет сгенерирован автоматически. В случае, если в нем есть какая-то ошибка, или ты "
        "считаешь, что он был назначен на тебя по ошибке, просьба написать об этом на рассылку "
        "mailto:cloud-compliance@yandex-team.ru или в ((https://t.me/joinchat/D98VvhRohkGmig3iRM7FFQ телеграм-чат YC Compliance))."
    )
    AWARENESS_TASK_CHECKLIST = [
        {
            "text": "Расписаться за ознакомление с документами. В период работы из дома достаточно оставить комментарий в тикете, "
            "в который в скором времени тебя призовут коллеги из HR. Обычные подписи будут собираться после выхода в офис."
        },
        {"text": "Ознакомиться с документами/другими полезными источниками информации"},
        {"text": "Пройти обучения"},
        {"text": "Проверить, что включено шифрование диска"},
        {"text": "Настроить аутентификацию"},
        {"text": "Настроить рабочую станцию"},
        {"text": "Проверить рабочий стол и стены"},
        {"text": "Проверить роль"},
        {"text": "Подписаться на рассылки"},
        {"text": "Подписаться на каналы в телеграмме"},
    ]
    AWARENESS_TASK_FOLLOWERS = [{"id": "semen-tarasov"}, {"id": "yrovenskiy"}]
    AWARENESS_TASK_TAGS = ["compliance_awareness"]

    COURSES_TASK_QUEUE = "CLOUD"
    COURSES_TASK_SUMMARY = "Обучение"
    COURSES_TASK_TEXT = (
        "Привет!\nНапоминаем, что в соответствии с "
        "((https://wiki.yandex-team.ru/cloud/regulations/awareness/ Политикой обучения)) "
        "все сотрудники участвующие в деятельности "
        "Яндекс.Облака обязаны проходить курсы повышения квалификации и соответствующие "
        "им тестирования.\n\nВ ходе автоматической проверки мы обнаружили что у тебя не "
        "завершены следующие курсы на платформе ((https://moe.yandex-team.ru Мёбиус)):\n{}\n\nПросьба в ближайшее "
        "время пройти эти курсы и тестирования, привязанные к ним. Пройденным считается курс, при наборе в тесте "
        "((https://wiki.yandex-team.ru/cloud/compliance/iso-checklist/#projjtiobuchenija более 70% правильных ответов)).\n\n"
        "P.S. Данный тикет сгенерирован автоматически. В случае, если в нем есть какая-"
        "то ошибка, или ты считаешь, что он был назначен на тебя по ошибке, просьба "
        "написать об этом на рассылку mailto:cloud-compliance@yandex-team.ru или в телеграм-чат "
        "((https://t.me/joinchat/D98VvhRohkGmig3iRM7FFQ YC Compliance))."
    )
    COURSES_TASK_FOLLOWERS = [{"id": "semen-tarasov"}, {"id": "yrovenskiy"}]
    COURSES_TASK_TAGS = ["compliance_courses"]

    SEC_DEV_COURSE_TASK_QUEUE = "CLOUD"
    SEC_DEV_COURSE_TASK_SUMMARY = "Обучение [Безопасная разработка]"
    SEC_DEV_COURSE_TASK_TEXT = (
        "Привет!\n"
        "В соответствии с ((https://wiki.yandex-team.ru/cloud/regulations/awareness/ Политикой обучения)) все сотрудники "
        "участвующие в деятельности Яндекс.Облака должны проходить обучение не реже раза в год.\n\n"
        "Недавно был обновлен онлайн-курс по безопасной разработке.\n"
        "В нем описаны основные уязвимости и методы защиты от них. Это важные знания, которые позволят делать Облако "
        "безопасным и выполнять требования Compliance.\n\n"
        "Тебе необходимо пройти ((https://moe.yandex-team.ru/courses/my/course/1010 обновленный курс по безопасной "
        "разработке)), код – 7NGZ3V2Z, прохождение курса не займет много времени.\n"
        "Курс будет засчитан как пройденный при наборе более 70% правильных ответов в тесте.\n\n"
        "В связи с тем, что это новый курс и ты проходишь его одним из первых, коллеги из Службы Информационной "
        "Безопасности будут очень признательны за фидбек. Его можно оставить в свободной форме или ответить на вопросы:\n"
        "* Что понравилось?\n"
        "* Что не понравилось?\n"
        "* Всё ли было понятно?\n"
        "* Были ли замечены какие-то опечатки?\n\n"
        "P.S. Данный тикет сгенерирован автоматически. В случае, если в нем есть какая-то ошибка, или ты считаешь, "
        "что он был назначен на тебя по ошибке, просьба написать об этом на рассылку "
        "mailto:cloud-compliance@yandex-team.ru или в телеграм-чат ((https://t.me/joinchat/D98VvhRohkGmig3iRM7FFQ YC Compliance))."
    )
    SEC_DEV_COURSE_TASK_FOLLOWERS = [
        {"id": "semen-tarasov"},
        {"id": "yrovenskiy"},
        {"id": "a-maksimova"},
    ]
    SEC_DEV_COURSE_TASK_TAGS = ["compliance_courses"]

    COURSES_IDS = {"15", "184", "317", "464", "1010"}

    EMAIL_SENDER = "robot-yc-compliance@yandex-team.ru"
    EMAIL_TARGET = "cloud-compliance@yandex-team.ru"
    SMTP_SERVER = "yabacks.yandex.ru"

    MSG_MAIN = "Задача в Sandbox выполнена.\n Состояние тикетов можно отследить на дашборде - https://st.yandex-team.ru/dashboard/38152"
    MSG_MAIN_NO_NOSIGN = (
        "{}\nСотрудников без тикета на подписание ознакомления с документами не обнаружено."
    )
    MSG_MAIN_NEW_ST = "{}\nСоздан тикет на подписание сотрудниками ознакомления с документами - {}"
    MSG_MAIN_OPENED_ST = "{}\nНа текущий момент открыты следующие тикеты на подписание ознакомления с документами - {}\n"
    MSG_MAIN_CLOSED_ST = "{}\nТикеты {} на подписание были закрыты, сотрудники, указанные в тикетах отмечаны как подписавшие документы."
    MSG_MAIN_DEVEL = "{}Письмо про devel отправлено следующим получателям - {}\n"
    MSG_MAIN_AW = "{}Созданы Awareness тикеты - {}\n"
    MSG_MAIN_MOE = "{}Созданы тикеты про обучения - {}\n"
    MSG_MAIN_ENCR = "{}Созданы тикеты на шифрование - {}\n"
    MSG_MAIN_AV = "{}Созданы тикеты на AV - {}\n"
    MSG_MAIN_SUBJECT = "Clouds Employees Inventory Task"
    MSG_STATS = (
        "{0}\n\nСтатистика по текущему состоянию:"
        "\nПодписали все документы - {1:.1f}%"
        "\nПодписаны на devel - {2:.1f}%\n"
        'Прошли курс "Защита приватных данных" - {3:.1f}%\n'
        'Прошли курс "Основы безопасной разработки в Яндекс.Облаке" - {4:.1f}%\n'
        'Прошли курс "Требования стандарта ISO-270x в области управления ИБ" - {5:.1f}%\n'
        'Прошли курс "Служба ITDC. Базовый уровень (Регламент работы со стойками CLOUD.)" - {6:.1f}%\n'
        "Зашифровано ПК (macOS, Windows) - {7:.1f}%\n"
        "Установлен AV - {8:.1f}%\n"
        "Включен FW - {9:.1f}%\n"
        "Роль не прописана в должностных обязаностях - {10:.1f}%\n\n"
    )
    MSG_SUBSCRIPTIONS = (
        "Привет!\n "
        "Мы подписали тебя на рассылку devel@yandex-team.ru.\n"
        "Через эту рассылку происходят все самые важные коммуникации с сотрудниками Яндекс.Облака. "
        "Также это необходимо для соответствия требованиям стандартов ISO 270xx\n"
        "Настроить способ получения писем ты можешь по ссылке "
        "https://ml.yandex-team.ru/lists/devel/. \n\n"
        "P.S. Данное письмо сгенерировано автоматически. В случае, если в нем есть какая-то "
        "ошибка, или ты считаешь что оно было доставлено тебе по ошибке, просьба написать об "
        "этом на рассылку cloud-compliance@yandex-team.ru или в телеграм-чат YC Compliance - "
        "https://t.me/joinchat/D98VvhRohkGmig3iRM7FFQ"
    )

    YT_MAC_TABLE = "//home/helpdesk/cmdb/jss_all/ext/jss/jss"
    YT_WIN_ENCRYPTION_TABLE = "//home/helpdesk/cmdb/sccm/encryptions_status/encryptions_status"
    YT_WIN_AV_FW_TABLE = "//home/cloud/compliance/av_fw_win"

    ROLES = (
        #  Роли Облачных сервисов
        "директор по развитию бизнеса",
        "генеральный директор",
        "операционный директор",
        "руководитель",
        "руководитель подразделения",
        "заместитель руководителя подразделения",
        "и.о. руководителя",
        "исполняющий обязанности руководителя",
        "заместитель руководителя",
        "менеджер по развитию бизнеса",
        "технический менеджер проектов",
        "tpm",
        "менеджер проектов",
        "дежурный инцидент-менеджер",
        "разработчик",
        "технический лидер",
        "стажер",
        "стажер-разработчик",
        "дежурный администратор",
        "специалист поддержки",
        "старший оператор",
        "инженер",
        "младший инженер",
        "сетевой инженер",
        "ведущий сетевой инженер",
        "старший сетевой инженер",
        "маркетолог",
        "pr-менеджер",
        "технический евангелист",
        "технический писатель",
        "менеджер обучающих программ",
        "архитектор",
        "ассистент руководителя",
        "аналитик",
        "дизайнер коммуникаций",
        "дизайнер продукта",
        "тимлид",
        #  Роли смежных сервисов
        "it специалист",
        "старший it специалист",
        "ведущий специалист",
        "руководитель it поддержки дц",
        "старший it специалист",
        "ведущий it специалист",
        "руководитель второй линии поддержки",
        "специалист по складской логистике",
        "специалист",
        "главный специалист",
        "старший специалист",
        "логист",
        "менеджер",
        "руководитель группы грузовой логистики",
        "руководитель группы транспорта",
        "руководитель группы учета",
        "водитель",
        "эксперт по информационной безопасности",
        "менеджер суиб",
        "аналитик информационной безопасности",
        "ведущий инженер иб",
        "инженер",
        "ответственный за сервис",
        "дежурный по сервису",
        "ответственный за инструмент",
        "разработчик инструмента",
        "руководитель отдела ит аудита",
        "менеджер по it аудиту",
        "специалист по ит аудиту",
    )
