# -*- coding: utf-8 -*-

import datetime
from sandbox import sdk2
from sandbox.sdk2 import yav


class Secrets:
    def __init__(self):
        self.secret = yav.Secret("sec-01dvx104f3y3515tmxc6wx3f53")

        self.db_password = self.secret.data().get("db_password", None)
        assert self.db_password, "Problem with DB password!"

        self.st_token = self.secret.data().get("st_token", None)
        assert self.st_token, "Problem with ST token!"


class DataBase:
    def __init__(self, table_name):
        secrets = Secrets()
        self.table_name = table_name
        self.db_password = secrets.db_password

        self.connection = self.connect()
        self.columns = self.get_columns()
        self.data_dict = self.get_data()

    def connect(self):
        import psycopg2

        connection_params = ("host=c-mdbl1if2iee71tvvbnq8.rw.db.yandex.net\n"
                             "port=6432\n"
                             "dbname=checkdb\n"
                             "user=robot\n"
                             "password={}\n"
                             "target_session_attrs=read-write").format(self.db_password)

        connection = psycopg2.connect(connection_params)
        connection.autocommit = True

        return connection

    def get_columns(self):
        from psycopg2.extras import DictCursor
        cursor = self.connection.cursor(cursor_factory=DictCursor)
        cursor.execute("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = N'{}'".format(self.table_name))
        request_output = cursor.fetchall()
        columns = [column[3] for column in request_output]
        cursor.close()

        return columns

    def get_data(self):
        from psycopg2.extras import DictCursor
        cursor = self.connection.cursor(cursor_factory=DictCursor)
        cursor.execute("SELECT * FROM {}".format(self.table_name))
        request_output = cursor.fetchall()
        data_dict = {}
        for item in request_output:
            data_dict.setdefault(item[0], dict())
            i = 1
            for column in self.columns[1:]:
                data_dict[item[0]].update({column: item[i]})
                i += 1

        cursor.close()

        return data_dict

    def push_metrics(self, metrics):
        import datetime

        sql_query_prepare_metrics = ("PREPARE push (date, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int) "
                                     "AS INSERT INTO metrics "
                                     "VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18, $19, $20, $21, $22, $23, $24, $25, $26, $27) ON CONFLICT (date) "
                                     "DO UPDATE SET date = $1, rar_1_compliant = $2, rar_1_not_compliant = $3, rar_2_compliant = $4, rar_2_not_compliant = $5, cm_1_compliant = $6, "
                                     "cm_1_not_compliant = $7, cm_2_compliant = $8, cm_2_not_compliant = $9, rm_1_not_compliant = $10, rm_2_compliant = $11, rm_2_not_compliant = $12, "
                                     "rm_3_compliant = $13, rm_3_not_compliant = $14, cm_3_compliant = $15, cm_3_not_compliant = $16, im_1_not_compliant = $17, ib_1_compliant = $18, "
                                     "ib_1_not_compliant = $19, ib_2_compliant = $20, ib_2_not_compliant = $21, es_1_compliant = $22, es_1_not_compliant = $23, rm_1_compliant = $24, "
                                     "im_1_compliant = $25, p_1_compliant = $26, p_1_not_compliant = $27; "
                                     "EXECUTE push('{0}','{1}','{2}','{3}','{4}','{5}','{6}','{7}','{8}','{9}','{10}','{11}','{12}','{13}','{14}','{15}','{16}','{17}','{18}','{19}',"
                                     "'{20}','{21}','{22}','{23}','{24}','{25}','{26}');")

        cursor = self.connection.cursor()
        cursor.execute(
            sql_query_prepare_metrics.format(datetime.datetime.now(), metrics["rar_1_compliant"], metrics["rar_1_not_compliant"], metrics["rar_2_compliant"], metrics["rar_2_not_compliant"],
                                             metrics["cm_1_compliant"], metrics["cm_1_not_compliant"], metrics["cm_2_compliant"], metrics["cm_2_not_compliant"], metrics["rm_1_not_compliant"],
                                             metrics["rm_2_compliant"], metrics["rm_2_not_compliant"], metrics["rm_3_compliant"], metrics["rm_3_not_compliant"], metrics["cm_3_compliant"],
                                             metrics["cm_3_not_compliant"], metrics["im_1_not_compliant"], metrics["ib_1_compliant"], metrics["ib_1_not_compliant"], metrics["ib_2_compliant"],
                                             metrics["ib_2_not_compliant"], metrics["es_1_compliant"], metrics["es_1_not_compliant"], metrics["rm_1_compliant"], metrics["im_1_compliant"],
                                             metrics["p_1_compliant"], metrics["p_1_not_compliant"]))

        cursor.close()


class Metrics:
    def __init__(self):
        from startrek_client import Startrek

        secrets = Secrets()
        self.st_token = secrets.st_token
        self.st_client = Startrek(useragent="RobotYCComplince", token=self.st_token)

        self.metrics_db = DataBase("metrics")
        self.employees_db = DataBase("employees")
        self.courses_db = DataBase("courses")
        self.computers_db = DataBase("computers")
        self.checklists_db = DataBase("checklists")
        self.privacy_tickets_db = DataBase("privacy_tickets")

        self.all = dict()
        for column in self.metrics_db.columns[1:]:
            self.all.setdefault(column, 0)

        self.count_rar_metrics()
        self.count_cm_metrics()
        self.count_rm_metrics()
        self.count_im_metrics()
        self.count_ib_metrics()
        self.count_es_metrics()
        self.count_p_metrics()

    def count_rar_metrics(self):
        for values in self.employees_db.data_dict.values():
            if values["cloud_relation"] == "clouds_employee" and values["is_external"] is False:
                if values["role_check_passed"]:
                    self.all["rar_1_compliant"] += 1
                else:
                    self.all["rar_1_not_compliant"] += 1

            if values["cloud_relation"] == "clouds_employee" and values["is_external"] is False:
                if values["docs_signed"]:
                    self.all["rar_2_compliant"] += 1
                else:
                    self.all["rar_2_not_compliant"] += 1

    def count_cm_metrics(self):
        ITDC_DEPARTMENTS = [
            "Группа IT поддержки ДЦ Мытищи",
            "Группа эксплуатации ДЦ «Мытищи»",
            "Группа IT поддержки ДЦ Сасово",
            "Группа эксплуатации ДЦ «Сасово»",
            "Группа IT поддержки ДЦ Владимир",
            "Группа эксплуатации ДЦ «Владимир»",
        ]

        for login, values in self.employees_db.data_dict.items():
            if values["cloud_relation"] == "clouds_employee" and values["is_external"] is False:
                if login in self.courses_db.data_dict:
                    if self.courses_db.data_dict[login]["15_result"] > 69:
                        self.all["cm_1_compliant"] += 1
                    else:
                        self.all["cm_1_not_compliant"] += 1

                    if self.courses_db.data_dict[login]["1010_result"] > 69 and values["is_developer"]:
                        self.all["cm_2_compliant"] += 1
                    elif self.courses_db.data_dict[login]["1010_result"] < 69 and values["is_developer"]:
                        self.all["cm_2_not_compliant"] += 1
                elif values["is_developer"]:
                    self.all["cm_2_not_compliant"] += 1
                    self.all["cm_1_not_compliant"] += 1
                else:
                    self.all["cm_1_not_compliant"] += 1
            if values["staff_department"] in ITDC_DEPARTMENTS and "ежурный" in values["position"] and values["is_external"] is False and values["cloud_relation"] != "out":
                if login in self.courses_db.data_dict:
                    if self.courses_db.data_dict[login]["1846_result"] > 69:
                        self.all["cm_3_compliant"] += 1
                    else:
                        self.all["cm_3_not_compliant"] += 1
                else:
                    self.all["cm_3_not_compliant"] += 1

    def count_rm_metrics(self):
        issues = self.st_client.issues.find(query='Queue: CLOUDRISKS Status: ! "Отклонен"', per_page=10000)
        for issue in issues:
            if issue.riskLevel in ("высокий", "критичный") and issue.solutionForTreatment == "принят":
                self.all["rm_1_not_compliant"] += 1
            elif issue.riskLevel in ("высокий", "критичный"):
                self.all["rm_1_compliant"] += 1
            if issue.status.name in ("В работе", "Принят", "Избегается", "Устранен"):
                self.all["rm_2_compliant"] += 1
            else:
                self.all["rm_2_not_compliant"] += 1
            if issue.status.name in ("Принят", "Устранен", "Избегается"):
                self.all["rm_3_compliant"] += 1
            else:
                self.all["rm_3_not_compliant"] += 1

    def count_im_metrics(self):
        issues = self.st_client.issues.find(query='Queue: CLOUDINC Created: > now() - 92d', per_page=10000)
        for issue in issues:
            if issue.priority.name == "Критичный" or issue.priority.name == "Блокер":
                self.all["im_1_not_compliant"] += 1
            else:
                self.all["im_1_compliant"] += 1

    def count_ib_metrics(self):
        for values in self.checklists_db.data_dict.values():
            if values["50"]:
                self.all["ib_1_compliant"] += 1
                self.all["ib_2_compliant"] += 1
            else:
                self.all["ib_1_not_compliant"] += 1
                self.all["ib_2_not_compliant"] += 1

    def count_es_metrics(self):
        logins_list = [login for login, values in self.employees_db.data_dict.items() if values["cloud_relation"] == "clouds_employee" and values["is_external"] is False]
        for values in self.computers_db.data_dict.values():
            if values["login"] in logins_list:
                if values["encrypted"] == "true":
                    self.all["es_1_compliant"] += 1
                elif values["encrypted"] == "false":
                    self.all["es_1_not_compliant"] += 1

    def count_p_metrics(self):
        for values in self.privacy_tickets_db.data_dict.values():
            if (values["created"] > (datetime.date.today() - datetime.timedelta(days=92))):
                if (values["open_days"]) <= 30:
                    self.all["p_1_compliant"] += 1
                else:
                    self.all["p_1_not_compliant"] += 1


class ComplianceMetricsParser(sdk2.Task):
    def on_execute(self):
        metrics = Metrics()
        metrics_db = DataBase("metrics")
        metrics_db.push_metrics(metrics.all)
