# -*- coding: utf-8 -*-

import logging
import os

from sandbox import sdk2
from sandbox.sdk2 import yav


class ComputersStatusesParser(sdk2.Task):
    def init(self):
        logging.info("Getting secrets, setting configuration.")

        self.SQL_CONNECTION_PARAMS = ("host=c-mdbl1if2iee71tvvbnq8.rw.db.yandex.net\n" "port=6432\n" "dbname=checkdb\n" "user=robot\n" "password={}\n" "target_session_attrs=read-write")
        self.SQL_QUERY_PREPARE = ("PREPARE push (text, text, text, text, text, text, text) "
                                  "AS INSERT INTO computers "
                                  "VALUES ($1, $2, $3, $4, $5, $6, $7) ON CONFLICT (hostname) "
                                  "DO UPDATE SET hostname = $1, login = $2, encrypted = $3, av_status = $4, "
                                  "fw_status = $5, os = $6, serial = $7;"
                                  "EXECUTE push($${0}$$,'{1}','{2}','{3}','{4}','{5}','{6}');")

        self.YT_MAC_TABLE = "//home/helpdesk/cmdb/jss_all/ext/jss/jss"
        self.YT_WIN_ENCRYPTION_TABLE = ("//home/helpdesk/cmdb/sccm/encryptions_status/encryptions_status")
        self.YT_WIN_AV_FW_TABLE = "//home/cloud/compliance/av_fw_win"

        secret = yav.Secret("sec-01dvx104f3y3515tmxc6wx3f53")

        yt_token = secret.data().get("yt_token", None)

        if yt_token is not None:
            os.environ["YT_TOKEN"] = yt_token
        else:
            raise Exception("Problem with yt_token!")

        self.db_password = secret.data().get("db_password", None)
        if self.db_password is None:
            raise Exception("Problem with DB password!")

    def encryption_status_set(self, yt_data):
        import yt.wrapper as yt

        yt.config.set_proxy("hahn")
        for record in yt.read_table(self.YT_MAC_TABLE, format="json"):
            hostname_with_sn = "{} (SN:{})".format(record["computer_name"], record["serial_number"])
            if record["computer_name"] not in yt_data:
                yt_data.setdefault(record["computer_name"], {})
                yt_data[record["computer_name"]].update({
                    "login": record["username"],
                    "os": record["operating_system"],
                    "serial": record["serial_number"],
                    "encrypted": "false" if record["filevault_2_status"] == "No Partitions Encrypted" else "true",
                })
            elif (yt_data[record["computer_name"]]["serial"] != record["serial_number"] and yt_data[record["computer_name"]]["login"] != record["username"]):
                yt_data.setdefault(hostname_with_sn, {})
                yt_data[hostname_with_sn].update({
                    "login": record["username"],
                    "os": record["operating_system"],
                    "serial": record["serial_number"],
                    "encrypted": "false" if record["filevault_2_status"] == "No Partitions Encrypted" else "true",
                })
            elif hostname_with_sn in yt_data:
                yt_data[hostname_with_sn].update({
                    "os": record["operating_system"],
                    "encrypted": "false" if record["filevault_2_status"] == "No Partitions Encrypted" else "true",
                })
            else:
                yt_data[record["computer_name"]].update({
                    "os": record["operating_system"],
                    "encrypted": "false" if record["filevault_2_status"] == "No Partitions Encrypted" else "true",
                })

        for record in yt.read_table(self.YT_WIN_ENCRYPTION_TABLE, format="json"):
            if record["DriveLetter"] == "C:":
                yt_data.setdefault(record["ComputerName"], {})
                yt_data[record["ComputerName"]].update({
                    "login": record["UserName"],
                    "os": "Windows",
                    "serial": record["SerialNumber"],
                    "encrypted": "true" if record["ProtectionStatus"] == "Зашифрован" else "false",
                })

        return yt_data

    def av_fw_status_set(self, yt_data):
        import yt.wrapper as yt

        yt.config.set_proxy("hahn")
        for record in yt.read_table(self.YT_MAC_TABLE, format="json"):
            hostname_with_sn = "{} (SN:{})".format(record["computer_name"], record["serial_number"])
            if record["computer_name"] not in yt_data:
                yt_data.setdefault(record["computer_name"], {})
                yt_data[record["computer_name"]].update({
                    "login": record["username"],
                    "os": record["operating_system"],
                    "serial": record["serial_number"],
                    "av_status": "installed" if "osquery_installed" in record["soc_status"] else "not installed",
                    "fw_status": "enabled" if record["firewall"] == "On" or record["firewall"] == "Block all incoming" else "disabled",
                })
            elif (yt_data[record["computer_name"]]["serial"] != record["serial_number"] and yt_data[record["computer_name"]]["login"] != record["username"]):
                yt_data.setdefault(hostname_with_sn, {})
                yt_data[hostname_with_sn].update({
                    "login": record["username"],
                    "os": record["operating_system"],
                    "serial": record["serial_number"],
                    "av_status": "installed" if "osquery_installed" in record["soc_status"] else "not installed",
                    "fw_status": "enabled" if record["firewall"] == "On" or record["firewall"] == "Block all incoming" else "disabled",
                })
            elif hostname_with_sn in yt_data:
                yt_data[hostname_with_sn].update({
                    "os": record["operating_system"],
                    "av_status": "installed" if "osquery_installed" in record["soc_status"] else "not installed",
                    "fw_status": "enabled" if record["firewall"] == "On" or record["firewall"] == "Block all incoming" else "disabled",
                })
            else:
                yt_data[record["computer_name"]].update({
                    "os": record["operating_system"],
                    "av_status": "installed" if "osquery_installed" in record["soc_status"] else "not installed",
                    "fw_status": "enabled" if record["firewall"] == "On" or record["firewall"] == "Block all incoming" else "disabled",
                })

        for record in yt.read_table(self.YT_WIN_AV_FW_TABLE, format="json"):
            if record["ComputerName"] in yt_data:
                yt_data[record["ComputerName"]].update({
                    "login": record["UserName"],
                    "os": "Windows",
                    "av_status": "enabled" if record["AntivirusState"] == "Enabled" else "disabled",
                    "fw_status": "enabled" if record["FirewallState"] == "Enabled" else "disabled",
                })

        return yt_data

    def db_push(self, yt_data):
        import psycopg2

        db_data = dict()
        for host in yt_data:
            db_data.setdefault(
                host,
                {
                    "encrypted": "No information",
                    "av_status": "No information",
                    "fw_status": "No information",
                    "serial": "No information",
                },
            )
            db_data[host].update(yt_data[host])

        logging.info("Connecting to DB.")
        connection = psycopg2.connect(self.SQL_CONNECTION_PARAMS.format(self.db_password))
        connection.autocommit = True

        cursor = connection.cursor()
        cursor.execute("DELETE FROM computers;")
        for key, value in db_data.items():
            cursor.execute(self.SQL_QUERY_PREPARE.format(
                key,
                value["login"],
                value["encrypted"],
                value["av_status"],
                value["fw_status"],
                value["os"],
                value["serial"],
            ))

        cursor.close()

    def on_execute(self):
        self.init()
        yt_data = dict()
        yt_data = self.encryption_status_set(yt_data)
        yt_data = self.av_fw_status_set(yt_data)

        self.db_push(yt_data)
