# -*- coding: utf-8 -*-

import json
import requests
import logging
import time

from sandbox import sdk2
from sandbox.sdk2 import yav


class CoursesResultsParser(sdk2.Task):
    def init(self):
        """
        Конструктор. Дергает серкреты из YAV.
        """

        logging.info("Getting secrets.")

        self.TVM_ID_MOE = "2001279"
        self.TVM_ID_CLOUD = "2018276"
        self.COURSES_IDS = {"15", "1846", "1010", "1298"}
        self.SQL_CONNECTION_PARAMS = ("host=c-mdbl1if2iee71tvvbnq8.rw.db.yandex.net\n" "port=6432\n" "dbname=checkdb\n" "user=robot\n" "password={}\n" "target_session_attrs=read-write")
        self.SQL_QUERY_PREPARE = ("PREPARE push (text, numeric, date, numeric, date, numeric, date, numeric, "
                                  "date) AS INSERT INTO courses "
                                  "VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9) ON CONFLICT (login) "
                                  'DO UPDATE SET login = $1, "15_result" = $2, "15_date" = $3, "1010_result" = $4, '
                                  '"1010_date" = $5, "1846_result" = $6, "1846_date" = $7, "1298_result" = $8, "1298_date" = $9;'
                                  "EXECUTE push('{0}','{1}','{2}','{3}','{4}','{5}','{6}','{7}','{8}');")

        secret = yav.Secret("sec-01dvx104f3y3515tmxc6wx3f53")

        self.db_password = secret.data().get("db_password", None)
        if self.db_password is None:
            raise Exception("Problem with DB password!")

        self.tvm_secret = secret.data().get("tvm_secret", None)
        if self.tvm_secret is None:
            raise Exception("Problem with TVM secret!")

        self.moe_tvm_ticket = self.tvm_tickets_get()

    def tvm_tickets_get(self):
        """
        Получение TVM тикетов для аутентификации.
        :return: TVM тикеты для аутентификации.
        """

        from tvm2 import TVM2
        from tvm2.protocol import BlackboxClientId

        logging.info("Getting TVM ticket.")

        tvm = TVM2(
            client_id=self.TVM_ID_CLOUD,
            secret=self.tvm_secret,
            blackbox_client=BlackboxClientId.Prod,
        )
        service_tickets = tvm.get_service_tickets(self.TVM_ID_MOE)
        moe_tvm_ticket = service_tickets.get(self.TVM_ID_MOE)

        return moe_tvm_ticket

    def moe_get(self):
        """
        Получение данных из Мебиуса.
        :return:      данные из Мебиуса.
        """

        logging.info("Getting data from MOE.")

        moe_data = dict()
        for course in self.COURSES_IDS:
            page = 1
            while page:
                response = requests.get(
                    url="https://api.moe.yandex-team.ru/api/v3/courses/{}/students_results/?page={}&page_size=500".format(course, page),
                    headers={"X-Ya-Service-Ticket": self.moe_tvm_ticket},
                    verify=False,
                )
                logging.info("Got info for course {}, page {}. Status code {}.".format(course, page, response.status_code))
                if response.status_code != 200:
                    i = 1
                    logging.info("Got {}.".format(response.status_code))
                    while response.status_code != 200 and i <= 10:
                        time.sleep(5)
                        logging.info("Trying again #{}".format(i))
                        response = requests.get(
                            url="https://api.moe.yandex-team.ru/api/v3/courses/{}/students_results/?page={}&page_size=500".format(course, page),
                            headers={"X-Ya-Service-Ticket": self.moe_tvm_ticket},
                            verify=False,
                        )
                        i += 1
                        data = json.loads(response.content)
                    if response.status_code != 200 and i == 10:
                        raise Exception("Problem with moe api!")
                else:
                    data = json.loads(response.content)

                for record in data["results"]:
                    if course == "15":
                        moe_data.setdefault(record["login"], {})
                        moe_data[record["login"]]["15_result"] = 0
                        moe_data[record["login"]]["15_date"] = "1900-1-1"
                        if len(record["clessons"]) != 0:
                            for clesson in record["clessons"]:
                                if clesson["clesson_id"] == 69:
                                    if len(clesson) != 0:
                                        moe_data[record["login"]]["15_result"] = clesson["result"]["percent"]
                                        if moe_data[record["login"]]["15_result"] != 0:
                                            moe_data[record["login"]]["15_date"] = clesson["result"]["last_modified"]
                    if course == "1010":
                        moe_data.setdefault(record["login"], {})
                        moe_data[record["login"]]["1010_result"] = 0
                        moe_data[record["login"]]["1010_date"] = "1900-1-1"
                        if len(record["clessons"]) != 0:
                            for clesson in record["clessons"]:
                                if clesson["clesson_id"] == 6283 and len(clesson) != 0:
                                    moe_data[record["login"]]["1010_result"] = clesson["result"]["percent"]
                                    if moe_data[record["login"]]["1010_result"] != 0:
                                        moe_data[record["login"]]["1010_date"] = clesson["result"]["last_modified"]
                    if course == "1298":
                        moe_data.setdefault(record["login"], {})
                        moe_data[record["login"]]["1298_result"] = 0
                        moe_data[record["login"]]["1298_date"] = "1900-1-1"
                        if len(record["clessons"]) != 0:
                            for clesson in record["clessons"]:
                                if clesson["clesson_id"] == 6279 and len(clesson) != 0:
                                    moe_data[record["login"]]["1298_result"] = clesson["result"]["percent"]
                                    if moe_data[record["login"]]["1298_result"] != 0:
                                        moe_data[record["login"]]["1298_date"] = clesson["result"]["last_modified"]
                    if course == "1846":
                        moe_data.setdefault(record["login"], {})
                        moe_data[record["login"]]["1846_result"] = 0
                        moe_data[record["login"]]["1846_date"] = "1900-1-1"
                        if len(record["clessons"]) != 0:
                            for clesson in record["clessons"]:
                                if clesson["clesson_id"] == 8370 and len(clesson) != 0:
                                    moe_data[record["login"]]["1846_result"] = clesson["result"]["percent"]
                                    if moe_data[record["login"]]["1846_result"] != 0:
                                        moe_data[record["login"]]["1846_date"] = clesson["result"]["last_modified"]

                page = data["next"]

        return moe_data

    def db_push(self, moe_data):
        import psycopg2

        db_data = dict()
        for login in moe_data:
            db_data.setdefault(
                login,
                {
                    "15_result": 0,
                    "15_date": "1900-1-1",
                    "1010_result": 0,
                    "1010_date": "1900-1-1",
                    "1846_result": 0,
                    "1846_date": "1900-1-1",
                    "1298_result": 0,
                    "1298_date": "1900-1-1",
                },
            )
            db_data[login].update(moe_data[login])

        logging.info("Connecting to DB.")

        connection = psycopg2.connect(self.SQL_CONNECTION_PARAMS.format(self.db_password))
        connection.autocommit = True

        logging.info("Pushing data to DB.")
        cursor = connection.cursor()
        for key, value in db_data.items():
            cursor.execute(
                self.SQL_QUERY_PREPARE.format(
                    key,
                    value["15_result"],
                    value["15_date"],
                    value["1010_result"],
                    value["1010_date"],
                    value["1846_result"],
                    value["1846_date"],
                    value["1298_result"],
                    value["1298_date"],
                ))

        cursor.close()

    def on_execute(self):
        self.init()
        moe_data = self.moe_get()
        self.db_push(moe_data)
