# -*- coding: utf-8 -*-


class ComponentsMap:
    """
    Структура карты:
        Очередь в трекере:
            Компонента в Coverity: Соответствующая ей компонента в Трекере

    Использование * для задания маски возможно только в начале или конце компоненты Coverity.
    В случае, если компонента в Трекере не нужна, надо к компоненте Coverity присвоить пустую строку - "".
    """

    MAP = {
        "CLOUD": {
            "cloud-java.resource-manager": "Resource Manager",
            "cloud-java.iam*": "IAM",
            "cloud-java.quota-service": "IAM",
            "cloud-java.fake-cloud": "fake-cloud",
            "cloud-java.trail*": "Audit Trails",
            "cloud-java.vpc-api": "VPC Config plane",
            "cloud-java.common*": "common-java",
            "cloud-go.iam": "IAM",
            "cloud-go.bastion": "Bastion",
            "cloud-go.schecker": "Schecker",
            "cloud-go.cloudgate": "VPC CloudGate",
            "cloud-go.healthcheck": "Network",
            "cloud-go.ifmap": "VPC Virtual Network",
            "cloud-go.apigateway": "platform-l7",
            "compute.common": "Compute: Common",
            "compute.api": "Compute: API",
            "compute.metadata": "Compute: Metadata",
            "compute.node": "Compute: Node",
            "compute.scheduler": "Compute: Node",
            "compute.serialproxy": "Compute: SerialSSH",
            "qemu.*": "Infrastructure - Hypervisor",
            "gobgp.*": "VPC CloudGate",
            "vpp.*": "VPC CloudGate",
            "contrail-yandex.*": "VPC Virtual Network",
            "arcadia.token-agent": "IAM",
        },
        "NBS": {
            "arcadia.blockstore-daemon": "",
            "arcadia.blockstore-libs": "",
            "arcadia.blockstore-client": "",
            "arcadia.blockstore-sdk-go-client": "",
            "arcadia.yc-disk-manager": "",
            "arcadia.yc-disk-manager-admin": "",
            "arcadia.yc-disk-manager-initdb": "",
            "arcadia.filestore": "",
        },
        "YQ": {
            "arcadia.YQ": "",
        }
    }
