# -*- coding: utf-8 -*-
import datetime
import logging
import requests
import json

from sandbox import sdk2
from sandbox.sdk2 import yav


class Secrets:
    def __init__(self):
        self.secret = yav.Secret("sec-01dvx104f3y3515tmxc6wx3f53")

        self.tvm_secret = self.secret.data().get("tvm_secret", None)
        assert self.tvm_secret, "Problem with TVM secret!"

        self.tvm_service_tickets = self.get_tvm()

        self.db_password = self.secret.data().get("db_password", None)
        assert self.db_password, "Problem with DB password!"

        oauth_token = self.secret.data().get("token", None)
        if oauth_token is not None:
            self.headers = {}
            self.headers["Authorization"] = "OAuth {}".format(oauth_token)
        else:
            raise Exception("Problem with token!")

    def get_tvm(self):
        from tvm2 import TVM2
        from tvm2.protocol import BlackboxClientId

        tvm = TVM2(
            client_id="2018276",
            secret=self.tvm_secret,
            blackbox_client=BlackboxClientId.Prod,
        )

        tvm_service_tickets = tvm.get_service_tickets("2020987")

        return tvm_service_tickets


class DataBase:
    SQL_QUERY_PREPARE = ("PREPARE push (text) "
                         "AS INSERT INTO employees "
                         "VALUES ($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15,$16) ON CONFLICT (login) "
                         "DO UPDATE SET login = $1, cloud_relation = $2, staff_department = $3, "
                         "location = $4, position = $5, devel_subscribed = $6, leads_subscribed = $7, "
                         "uid = $8, services = $9, role_check_passed = $10, added = $11, "
                         "last_update = $12, docs_signed = $13, docs_signing_ticket = $14, is_developer = $15, "
                         "is_external = $16;"
                         "EXECUTE push('{0}','{1}','{2}','{3}','{4}','{5}','{6}','{7}','{8}','{9}','{10}',"
                         "'{11}','{12}','{13}','{14}','{15}');")

    def __init__(self, secrets, table_name):
        self.table_name = table_name
        self.db_password = secrets.db_password

        self.connection = self.connect()
        self.columns = self.get_columns()
        self.data_dict = self.get_data()

    def connect(self):
        import psycopg2

        connection_params = ("host=c-mdbl1if2iee71tvvbnq8.rw.db.yandex.net\n"
                             "port=6432\n"
                             "dbname=checkdb\n"
                             "user=robot\n"
                             "password={}\n"
                             "target_session_attrs=read-write").format(self.db_password)

        connection = psycopg2.connect(connection_params)
        connection.autocommit = True

        return connection

    def get_columns(self):
        from psycopg2.extras import DictCursor
        cursor = self.connection.cursor(cursor_factory=DictCursor)
        cursor.execute("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = N'{}'".format(self.table_name))
        request_output = cursor.fetchall()
        columns = [column[3] for column in request_output]
        cursor.close()

        return columns

    def get_data(self):
        from psycopg2.extras import DictCursor

        logging.info("Getting DB.")
        cursor = self.connection.cursor(cursor_factory=DictCursor)
        cursor.execute("SELECT * FROM {}".format(self.table_name))
        request_output = cursor.fetchall()
        data_dict = {}
        for item in request_output:
            data_dict.setdefault(item[0], dict())
            i = 1
            for column in self.columns[1:]:
                data_dict[item[0]].update({column: item[i]})
                i += 1

        cursor.close()

        return data_dict

    def push_employees(self, data):
        logging.info("Pushing DB.")
        cursor = self.connection.cursor()
        for key, value in data.items():
            cursor.execute(
                self.SQL_QUERY_PREPARE.format(key, value["cloud_relation"], value["staff_department"], value["location"], value["position"], value["devel_subscribed"], value["leads_subscribed"],
                                              value["uid"], value["services"], value["role_check_passed"], value["added"], value["last_update"], value["docs_signed"], value["docs_signing_ticket"],
                                              value["is_developer"], value["is_external"]))

        cursor.close()


class Employees:
    def __init__(self, secrets, employees_db):
        self.empoyees_db_data = employees_db.data_dict
        self.secrets = secrets
        self.find_targets()

    def find_targets(self):
        self.targets = dict()
        for login, info in self.empoyees_db_data.items():
            if info["cloud_relation"] in ["clouds_employee", "connected_services_employee"] and info["is_external"] is False and info["docs_signing_ticket"] == "No information":
                self.targets.setdefault(login, {"cloud_relation": info["cloud_relation"]})
                api_params = {
                    "_fields": "login,name",
                    "_limit": "1000",
                    "login": "{}".format(login),
                }
                response = requests.post(url="https://staff-api.yandex-team.ru/v3/persons/", headers=self.secrets.headers, data=api_params)
                data = json.loads(response.content)
                self.targets[login]["name"] = data["result"][0]["name"]["first"]["ru"]
                self.targets[login]["last_name"] = data["result"][0]["name"]["last"]["ru"]

    def update_employees_db(self, targets):
        self.updated_empoyees_db_data = dict()
        for login, info in targets.items():
            self.updated_empoyees_db_data[login] = self.empoyees_db_data[login]
            self.updated_empoyees_db_data[login]["docs_signing_ticket"] = info["ticket"]
        pass


class CDoc:
    def __init__(self, secrets, targets):
        self.targets = targets
        self.tvm_service_tickets = secrets.tvm_service_tickets
        self.create_doc_ticket()

    def create_doc_ticket(self):
        for login, info in self.targets.items():
            logging.info("Creation ticket for {}.".format(login))
            if info["cloud_relation"] == "clouds_employee":
                tag = "compliance_awareness"
            elif info["cloud_relation"] == "connected_services_employee":
                tag = "compliance_awareness_connected"
            deadline = datetime.date.today() + datetime.timedelta(days=14)
            deadline = deadline.strftime("%d.%m.%Y")
            description = 'description,Привет!\n\n'\
                'Мы обнаружили, что у тебя есть доступ к внутренним системам Яндекс.Облака, которые могут содержать конфиденциальную информацию.\n'\
                'Для обеспечения должного уровня информационной безопасности этой информации, у нас в Облаке действует ряд правил, описанных во внутренних документах.\n\n'\
                'Для того, что бы знать и соблюдать эти правила, мы просим тебя под роспись ознакомиться с документами:\n'\
                '1. ((https://wiki.yandex-team.ru/security/policies/main/ Политика информационной безопасности Яндекса))\n'\
                '2. ((https://wiki.yandex-team.ru/cloud/regulations/yc-security-policy/ Политика информационной безопасности Яндекс.Облака))\n'\
                '3. ((https://wiki.yandex-team.ru/cloud/regulations/pd-processing-order/ Положение о порядке обработки ПДн))\n'\
                '4. ((https://wiki.yandex-team.ru/security/awareness/skarif/policy/ Политика использования приватных данных пользователей))\n'\
                '5. ((https://wiki.yandex-team.ru/cloud/security/compliance/pii-memo/ Памятка по работе с персональными и пользовательским данными))\n\n'\
                'Роспись необходима для подтверждения факта ознакомления на аудитах Облака.\n'\
                '!!Ознакомление необходимо завершить до **{}**.!!\n'\
                '!!В случае если ознакомление не будет завершено да этой даты, Облачные доступы, в том числе роли в Облачных сервисах (находящихся в иерархии ABC '\
                'под ((https://abc.yandex-team.ru/services/cloud/ Облаком))) могут быть отозваны.!!\n\n'\
                'P.S. Данный тикет сгенерирован автоматически. В случае, если в нем есть какая-то ошибка, или ты считаешь, что он был назначен на тебя по '\
                'ошибке, просьба написать об этом на рассылку cloud-compliance@yandex-team.ru или в телеграм-чат YC Compliance.'

            pre_body = '--boundary\r\nContent-Disposition: form-data; name="xxya_cdoc_format"\r\n\r\npdf\r\n'\
                    '--boundary\r\nContent-Disposition: form-data; name="docId"\r\n\r\n871\r\n'\
                    '--boundary\r\nContent-Disposition: form-data; name="startrekQueue"\r\n\r\nEDS\r\n'\
                    '--boundary\r\nContent-Disposition: form-data; name="staff_login"\r\n\r\n{}\r\n'\
                    '--boundary\r\nContent-Disposition: form-data; name="last_name"\r\n\r\n{}\r\n'\
                    '--boundary\r\nContent-Disposition: form-data; name="first_name"\r\n\r\n{}\r\n'\
                    '--boundary\r\nContent-Disposition: form-data; name="startrekIntegration"\r\n\r\nsummary,Ознакомление с ЛНА Яндекс.Облака\r\n'\
                    '--boundary\r\nContent-Disposition: form-data; name="startrekIntegration"\r\n\r\n{}\r\n'\
                    '--boundary\r\nContent-Disposition: form-data; name="startrekIntegration"\r\n\r\nfollowers,semen-tarasov, robot-yc-compliance\r\n'\
                    '--boundary\r\nContent-Disposition: form-data; name="startrekIntegration"\r\n\r\nassignee,robot-hr-salary\r\n'\
                    '--boundary\r\nContent-Disposition: form-data; name="startrekIntegration"\r\n\r\ncomponents,ЛНА облака\r\n'\
                    '--boundary\r\nContent-Disposition: form-data; name="startrekIntegration"\r\n\r\nemployee,{}\r\n'\
                    '--boundary\r\nContent-Disposition: form-data; name="startrekIntegration"\r\n\r\ndeadline,{}\r\n'\
                    '--boundary\r\nContent-Disposition: form-data; name="startrekIntegration"\r\n\r\ntags,{}\r\n'\
                    '--boundary\r\nContent-Disposition: form-data; name="fileName"\r\n\r\nЛист ознакомления\r\n'\
                    '--boundary--\r\n'

            body = pre_body.format(login, info["last_name"], info["name"], description.format(deadline), login, deadline, tag)
            logging.info(body.encode('utf-8'))
            headers = {}
            headers["Content-Type"] = "multipart/form-data; boundary=boundary"
            headers["X-Ya-Service-Ticket"] = self.tvm_service_tickets["2020987"]
            logging.info("login - {}, last_name - {}, first_name - {}".format(login, info["last_name"], info["name"]))
            response = requests.post(url="https://cdoc.yandex-team.ru/api/ticket/create", headers=headers, data=body.encode('utf-8'))
            if response.status_code == 200:
                self.targets[login]["ticket"] = response.text.replace("CREATED_TICKET ", "")
                logging.info("Created ticket {}.".format(self.targets[login]["ticket"]))
            else:
                raise Exception(self.exeption.format(response.status_code, response.text))


class DocsSigningTicketsCreator(sdk2.Task):
    def on_execute(self):
        secrets = Secrets()
        employees_db = DataBase(secrets, "employees")
        employees = Employees(secrets, employees_db)
        cdoc = CDoc(secrets, employees.targets)

        employees.update_employees_db(cdoc.targets)
        employees_db.push_employees(employees.updated_empoyees_db_data)
