# -*- coding: utf-8 -*-

import datetime
import json
import requests
import logging

from sandbox import sdk2
from sandbox.sdk2 import yav


class DutyCaller(sdk2.Task):
    def on_execute(self):
        from startrek_client import Startrek

        st_token = self.get_st_token()
        client = Startrek(useragent="CloudDutyCaller", token=st_token)
        tagret_tickets = client.issues.find('Queue: CLOUD Assignee: empty() Tags: "for_cloud_duty"')
        tagret_tickets = [ticket["key"] for ticket in tagret_tickets]
        for ticket in tagret_tickets:
            logging.info(
                "Ticket {} was found for duty without an assignee. Starting to analyze it.".format(
                    ticket
                )
            )
            issue = client.issues[ticket]
            components = issue["components"]
            components = [component.name.lower() for component in components]
            duty = None
            for component in components:
                try:
                    logging.info("Component is {}, trying to find duty.".format(component))
                    duty, backup = self.find_duty(self.map_service(component))
                    logging.info("Duty found. Modifying ticket.")
                except:
                    comments = list(issue.comments.get_all())
                    comments_text = "; ".join(
                        [comment["text"] for comment in comments if len(comments) != 0]
                    )
                    if "Обнаружен тег for_cloud_duty, но тикет не размечен" not in comments_text:
                        issue.comments.create(
                            text="Обнаружен тег for_cloud_duty, но тикет не размечен, так как дежурный для сервиса **{}** не найден в resps-api.cloud.yandex.net.".format(
                                self.map_service(component)
                            )
                        )
                        logging.info("Duty not found, comment added.")
                    else:
                        logging.info("Duty not found, comment already exist.")
                    pass
            if duty is not None:
                issue.update(assignee=duty)
                issue.comments.create(
                    text="Обнаружен тег for_cloud_duty, тикет размечен на дежурного."
                )
            duty_ticket = self.find_duty_ticket(component, client)
            if duty_ticket:
                logging.info("Duty ticket found. Adding link.")
                ticket.links.create(issue=duty_ticket, relationship="relates")

    def map_service(self, component):
        if component in (
            "compute: common",
            "compute: api",
            "compute: metadata",
            "compute: serialssh",
        ):
            return "compute-api"
        elif component in ("compute: node",):
            return "compute-node"
        elif component in ("compute: snapshot",):
            return "nbs"

        return component

    def get_st_token(self):
        secret = yav.Secret("sec-01eacm2q8py8kerwtsc61r7gcv")
        st_token = secret.data().get("st_token", None)
        if st_token is None:
            raise Exception("Problem with st_token!")

        return st_token

    def find_duty(self, service):
        today = datetime.datetime.now().strftime("%d-%m-%YT%H:%M")
        resp_api_params = {"from": today, "to": today}
        response = requests.get(
            url="https://resps-api.cloud.yandex.net/api/v0/duty/{}".format(service),
            params=resp_api_params,
        )
        if response.status_code == 200:
            data = json.loads(response.content)
            duty = "".join(
                str(duty["resp"]["username"]) for duty in data if duty["resp"]["order"] == 0
            )
            backup = "".join(
                str(duty["resp"]["username"]) for duty in data if duty["resp"]["order"] == 1
            )
            return duty, backup
        else:
            return

    def find_duty_ticket(self, component, client):
        issues = client.issues.find(
            'Queue: CLOUDDUTY Resolution: empty() Tags: "duty-ticket" Components: "{}"'.format(
                component
            )
        )
        if len(issues) == 1:
            return issues[0].key
        else:
            return
