# -*- coding: utf-8 -*-

import requests
import json

from sandbox import sdk2
from sandbox.sdk2 import yav


class Secrets:
    def __init__(self):
        self.secret = yav.Secret("sec-01dvx104f3y3515tmxc6wx3f53")

        self.db_password = self.secret.data().get("db_password", None)
        assert self.db_password, "Problem with DB password!"

        self.st_token = self.secret.data().get("st_token", None)
        assert self.st_token, "Problem with ST token!"

        self.oauth_token = self.secret.data().get("token", None)
        assert self.oauth_token, "Problem with OAuth token!"


class DataBase:
    def __init__(self, db_password, table_name):
        self.table_name = table_name
        self.db_password = db_password

        self.connection = self.connect()
        self.columns = self.get_columns()
        self.data_dict = self.get_data()

    def connect(self):
        import psycopg2

        connection_params = ("host=c-mdbl1if2iee71tvvbnq8.rw.db.yandex.net\n"
                             "port=6432\n"
                             "dbname=checkdb\n"
                             "user=robot\n"
                             "password={}\n"
                             "target_session_attrs=read-write").format(self.db_password)

        connection = psycopg2.connect(connection_params)
        connection.autocommit = True

        return connection

    def get_columns(self):
        from psycopg2.extras import DictCursor
        cursor = self.connection.cursor(cursor_factory=DictCursor)
        cursor.execute("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = N'{}'".format(self.table_name))
        request_output = cursor.fetchall()
        columns = [column[3] for column in request_output]
        cursor.close()

        return columns

    def get_data(self):
        from psycopg2.extras import DictCursor
        cursor = self.connection.cursor(cursor_factory=DictCursor)
        cursor.execute("SELECT * FROM {}".format(self.table_name))
        request_output = cursor.fetchall()
        data_dict = {}
        for item in request_output:
            data_dict.setdefault(item[0], dict())
            i = 1
            for column in self.columns[1:]:
                data_dict[item[0]].update({column: item[i]})
                i += 1

        cursor.close()

        return data_dict

    def push_teams_metrics(self, teams):
        sql_prepare = ("PREPARE push (text, text, int, int, int, int) AS INSERT INTO executive_teams_metrics VALUES ($1, $2, $3) ON CONFLICT (team) "
                       "DO UPDATE SET team = $1, team_name = $2, rar_compliant = $3, rar_not_compliant = $4, cm_compliant = $5, cm_not_compliant = $6; "
                       "EXECUTE push('{0}','{1}','{2}','{3}','{4}','{5}');")

        cursor = self.connection.cursor()
        for key, values in teams.items():
            cursor.execute(sql_prepare.format(key, values["team_name"], values["rar_compliant"], values["rar_not_compliant"], values["cm_compliant"], values["cm_not_compliant"]))

        cursor.close()


class API:
    def __init__(self, oauth_token):
        self.headers = {}
        self.headers["Authorization"] = "OAuth {}".format(oauth_token)

    def get(self, url, params):
        response = requests.get(headers=self.headers, url=url, params=params)
        if response.status_code == 200:
            data = json.loads(response.content)
        else:
            raise Exception("Problem with API ({}) connection, status code is {}. \n Text:\n{}\nData:\n{}".format(url, response.status_code, response.text, params))

        return data


class Teams:
    def __init__(self, oauth_token):
        self.api = API(oauth_token)
        self.teams = dict()

        self.teams_list_get()

    def teams_list_get(self):
        staff_teams_params = {
            "parent.department.url": "yandex_exp_9053",
        }
        data = self.api.get("https://staff-api.yandex-team.ru/v3/groups", staff_teams_params)
        for team in data["result"]:
            self.teams.update({team["url"]: dict()})
            self.teams[team["url"]].update({"team_name": team["name"]})

            staff_teams_members_params = {
                "_fields": "person.login",
                "_limit": 5000,
                "group.ancestors.department.url": team["url"],
                "person.official.is_dismissed": False,
                "person.official.is_robot": False,
            }
            team_members = self.api.get("https://staff-api.yandex-team.ru/v3/groupmembership", staff_teams_members_params)
            members = set([user["person"]["login"] for user in team_members["result"]])

            staff_teams_line_members_params = {
                "_fields": "person.login",
                "_limit": 5000,
                "group.url": team["url"],
                "person.official.is_dismissed": False,
                "person.official.is_robot": False,
            }
            team_line_members = self.api.get("https://staff-api.yandex-team.ru/v3/groupmembership", staff_teams_line_members_params)
            [members.add(user["person"]["login"]) for user in team_line_members["result"]]

            self.teams[team["url"]].update({"members": members})

    def get_teams_status(self, employees_db_data, courses_db_data):
        for team in self.teams:
            self.teams[team]["cm_compliant"] = 0
            self.teams[team]["cm_not_compliant"] = 0
            self.teams[team]["rar_compliant"] = 0
            self.teams[team]["rar_not_compliant"] = 0
            for member in self.teams[team]["members"]:
                if member in employees_db_data and member in courses_db_data:
                    if employees_db_data[member]["docs_signed"]:
                        self.teams[team]["rar_compliant"] += 1
                    else:
                        self.teams[team]["rar_not_compliant"] += 1

                    cm_compliant = True
                    if courses_db_data[member]["15_result"] < 70:
                        cm_compliant = False
                    if employees_db_data[member]["is_developer"] and courses_db_data[member]["1010_result"] < 70:
                        cm_compliant = False

                    if cm_compliant:
                        self.teams[team]["cm_compliant"] += 1
                    else:
                        self.teams[team]["cm_not_compliant"] += 1


class ExecutiveMetricsParser(sdk2.Task):
    def on_execute(self):
        secrets = Secrets()
        employees_db = DataBase(secrets.db_password, "employees")
        courses_db = DataBase(secrets.db_password, "courses")
        executive_teams_metrics_db = DataBase(secrets.db_password, "executive_teams_metrics")
        teams = Teams(secrets.oauth_token)

        teams.get_teams_status(employees_db.data_dict, courses_db.data_dict)
        executive_teams_metrics_db.push_teams_metrics(teams.teams)

        employees_db.connection.close()
        courses_db.connection.close()
        executive_teams_metrics_db.connection.close()
