# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sdk2 import yav


class Secrets:
    def __init__(self):
        secret = yav.Secret("sec-01dvx104f3y3515tmxc6wx3f53")

        self.st_token = secret.data().get("st_token", None)
        assert self.st_token, "Problem with ST token!"

        self.db_password = secret.data().get("db_password", None)
        assert self.db_password, "Problem with DB password!"


class DataBase:
    def db_connect(self, db_password):
        import psycopg2

        SQL_CONNECTION_PARAMS = ("host=c-mdbl1if2iee71tvvbnq8.rw.db.yandex.net\n" "port=6432\n" "dbname=checkdb\n" "user=robot\n" "password={}\n" "target_session_attrs=read-write")

        connection = psycopg2.connect(SQL_CONNECTION_PARAMS.format(db_password))
        connection.autocommit = True

        return connection

    def tickets_table_push(self, db_password, tickets):
        connection = self.db_connect(db_password)

        SQL_QUERY_PREPARE_TICKETS = ("PREPARE push (text,date,date,text,int,date) AS INSERT INTO privacy_tickets VALUES ($1,$2,$3,$4,$5,$6) ON CONFLICT (key) "
                                     "DO UPDATE SET key = $1, created = $2, updated = $3, status = $4, open_days = $5, "
                                     "status_changed = $6; EXECUTE push('{0}','{1}','{2}','{3}','{4}','{5}');")

        cursor = connection.cursor()
        for key, value in tickets.items():
            cursor.execute(SQL_QUERY_PREPARE_TICKETS.format(
                key,
                value["created"],
                value["updated"],
                value["status"],
                value["open_days"],
                value["status_changed"],
            ))

        connection.close()


class Tracker:
    def tickets_get(self, st_token):
        from startrek_client import Startrek
        from datetime import datetime

        client = Startrek(useragent="RobotYCComplince", token=st_token)
        tickets = dict()

        issues = client.issues.find(query='Queue: CLOUDSUPPORT Components: PD')

        for issue in issues:
            tickets[issue.key] = dict()
            tickets[issue.key]["created"] = issue.createdAt
            tickets[issue.key]["updated"] = issue.updatedAt
            tickets[issue.key]["status"] = issue.status.name
            tickets[issue.key]["status_changed"] = issue.statusStartTime
            if issue.status.name == "Закрыт":
                tickets[issue.key]["open_days"] = (datetime.strptime(issue.statusStartTime[:10], "%Y-%m-%d") - datetime.strptime(issue.createdAt[:10], "%Y-%m-%d")).days
            else:
                tickets[issue.key]["open_days"] = (datetime.today() - datetime.strptime(issue.createdAt[:10], "%Y-%m-%d")).days

        return tickets


class PrivacyTicketsParser(sdk2.Task):
    def on_execute(self):
        db = DataBase()
        st = Tracker()
        secrets = Secrets()

        tickets = st.tickets_get(secrets.st_token)

        db.tickets_table_push(secrets.db_password, tickets)
