# -*- coding: utf-8 -*-

import logging
from sandbox import sdk2
from sandbox.sdk2 import yav


class TicketsStatusesParser(sdk2.Task):
    def get_secrets(self):
        secret = yav.Secret("sec-01dvx104f3y3515tmxc6wx3f53")

        self.st_token = secret.data().get("st_token", None)
        assert self.st_token, "Problem with ST token!"

        self.db_password = secret.data().get("db_password", None)
        assert self.db_password, "Problem with DB password!"

    def db_connect(self):
        import psycopg2

        SQL_CONNECTION_PARAMS = ("host=c-mdbl1if2iee71tvvbnq8.rw.db.yandex.net\n" "port=6432\n" "dbname=checkdb\n" "user=robot\n" "password={}\n" "target_session_attrs=read-write")

        connection = psycopg2.connect(SQL_CONNECTION_PARAMS.format(self.db_password))
        connection.autocommit = True

        return connection

    def db_tickets_table_push(self, tickets, connection):
        SQL_QUERY_PREPARE_TICKETS = ("PREPARE push (text) AS INSERT INTO tickets "
                                     "VALUES ($1,$2,$3,$4,$5,$6) ON CONFLICT (key) "
                                     "DO UPDATE SET key = $1, status = $2, "
                                     "tag = $3, created = $4, updated = $5, assignee = $6;"
                                     "EXECUTE push('{0}','{1}','{2}','{3}','{4}','{5}');")

        cursor = connection.cursor()
        for key, value in tickets.items():
            cursor.execute(SQL_QUERY_PREPARE_TICKETS.format(
                key,
                value["status"],
                value["tag"],
                value["created"],
                value["updated"],
                value["assignee"],
            ))

    def tickets_get(self):
        from startrek_client import Startrek

        COMPLIANCE_TAGS = [
            "compliance_courses",
            "compliance_repassing_courses",
            "compliance_awareness",
            "compliance_encryption",
            "compliance_role",
        ]

        client = Startrek(useragent="RobotYCComplince", token=self.st_token)
        tickets = dict()

        logging.info("Start parsing CLOUD queue.")
        issues = client.issues.find(
            query="Queue: CLOUD Tags: {}".format(", ".join(COMPLIANCE_TAGS)),
            per_page=10000,
        )

        i = 0
        for issue in issues:
            tickets[issue.key] = dict()
            tickets[issue.key]["status"] = issue.status.name
            tickets[issue.key]["tag"] = ", ".join(tag for tag in issue.tags if tag in COMPLIANCE_TAGS)
            tickets[issue.key]["created"] = issue.createdAt
            tickets[issue.key]["updated"] = issue.updatedAt
            try:
                tickets[issue.key]["assignee"] = issue.assignee.login
            except AttributeError:
                tickets[issue.key]["assignee"] = "No assignee"
            i += 1
            logging.info("Parsed {} issue from {} issues.".format(i, len(issues)))

        logging.info("Start parsing EDS queue.")
        issues_eds = client.issues.find(
            query="Queue: EDS Tags: compliance_awareness",
            per_page=10000,
        )

        i = 0
        for issue in issues_eds:
            tickets[issue.key] = dict()
            tickets[issue.key]["status"] = issue.status.name
            tickets[issue.key]["tag"] = "compliance_awareness_eds"
            tickets[issue.key]["created"] = issue.createdAt
            tickets[issue.key]["updated"] = issue.updatedAt
            try:
                tickets[issue.key]["assignee"] = issue.employee.login
            except AttributeError:
                tickets[issue.key]["assignee"] = "No assignee"
            i += 1
            logging.info("Parsed {} issue from {} issues.".format(i, len(issues)))

        return tickets

    def on_execute(self):
        self.get_secrets()

        tickets = self.tickets_get()

        connection = self.db_connect()
        self.db_tickets_table_push(tickets, connection)
        connection.close()
