# -*- coding: utf-8 -*-

import logging
from sandbox import sdk2
from sandbox.sdk2 import yav


class Secrets:
    def __init__(self):
        self.secret = yav.Secret("sec-01dvx104f3y3515tmxc6wx3f53")

        self.st_token = self.secret.data().get("st_token", None)
        assert self.st_token, "Problem with ST token!"

        self.db_password = self.secret.data().get("db_password", None)
        assert self.db_password, "Problem with DB password!"

        self.oauth_token = self.secret.data().get("token", None)
        assert self.oauth_token, "Problem with TVM secret!"


class Tickets:
    def __init__(self, secrets, tickets, courses_db, employees_db):
        from startrek_client import Startrek
        self.secrets = secrets
        self.client = Startrek(useragent="RobotYCComplince", token=secrets.st_token)
        self.tickets = tickets.data_dict
        self.courses_db = courses_db.data_dict
        self.employees_db = employees_db.data_dict

        [self.tickets.pop(ticket) for ticket, params in self.tickets.copy().items() if params["assignee"] == "No assignee"]
        [self.tickets.pop(ticket) for ticket, params in self.tickets.copy().items() if params["status"] == "Закрыт"]
        [self.tickets.pop(ticket) for ticket in self.tickets.copy() if ticket[0:5] != "CLOUD"]

        [self.tickets[ticket].setdefault("dismissed", self.check_dismissal(params["assignee"])) for ticket, params in self.tickets.items()]
        [self.tickets[ticket].setdefault("courses_passed", self.check_courses(params["assignee"])) for ticket, params in self.tickets.items()]

    def check_dismissal(self, login):
        import requests
        import json

        api_url = "https://staff-api.yandex-team.ru/v3/persons/"
        api_params = {
            "_fields": "official.is_dismissed",
            "login": login,
        }

        headers = {}
        headers["Authorization"] = "OAuth {}".format(self.secrets.oauth_token)

        response = requests.post(url=api_url, headers=headers, data=api_params)
        if response.status_code == 201 or response.status_code == 200:
            data = json.loads(response.content)
            is_dismissed = data["result"][0]["official"]["is_dismissed"]
            return is_dismissed
        else:
            raise Exception("Problem with API ({}) connection, status code is {}. \n Text:\n{}\nData:\n{}".format(api_url, response.status_code, response.text, api_params))

    def check_courses(self, login):
        passed_15 = False
        passed_1010 = False
        courses_passed = False

        if login in self.employees_db and login in self.courses_db:
            if self.employees_db[login]["cloud_relation"] == "clouds_employee":
                passed_15 = self.courses_db[login]["15_result"] >= 70
                if self.employees_db[login]["is_developer"]:
                    if self.courses_db[login]["1010_result"] >= 70:
                        passed_1010 = True
                    courses_passed = passed_15 and passed_1010
                else:
                    courses_passed = passed_15

        return courses_passed

    def close_ticket_dismissed(self, ticket):
        logging.info("Closing ticket {} with dismissed employee.".format(ticket))
        issue = self.client.issues[ticket]
        transitions_list = [transition.id for transition in issue.transitions.get_all()]
        if "closed1" in transitions_list:
            transition = issue.transitions["closed1"]
            transition.execute(comment="Сотрудник уволен. Тикет более не актуален.", resolution="willNotFix")
            logging.info("Done.")
        elif "closed" in transitions_list:
            transition = issue.transitions["closed"]
            transition.execute(comment="Сотрудник уволен. Тикет более не актуален.", resolution="willNotFix")
            logging.info("Done.")
        else:
            logging.info("Transition is not available.")

    def close_ticket_courses(self, ticket):
        logging.info("Closing ticket {} with passed courses.".format(ticket))
        issue = self.client.issues[ticket]
        transitions_list = [transition.id for transition in issue.transitions.get_all()]
        if "closed1" in transitions_list:
            transition = issue.transitions["closed1"]
            transition.execute(comment="Все обучения пройдены, тикет закрывается.", resolution="fixed")
            logging.info("Done.")
        elif "closed" in transitions_list:
            transition = issue.transitions["closed"]
            transition.execute(comment="Все обучения пройдены, тикет закрывается.", resolution="fixed")
            logging.info("Done.")
        else:
            logging.info("Transition is not available.")


class DataBase:
    def __init__(self, db_password, table_name):
        self.table_name = table_name
        self.db_password = db_password

        self.connection = self.connect()
        self.columns = self.get_columns()
        self.data_dict = self.get_data()

    def connect(self):
        import psycopg2

        connection_params = ("host=c-mdbl1if2iee71tvvbnq8.rw.db.yandex.net\n"
                             "port=6432\n"
                             "dbname=checkdb\n"
                             "user=robot\n"
                             "password={}\n"
                             "target_session_attrs=read-write").format(self.db_password)

        connection = psycopg2.connect(connection_params)
        connection.autocommit = True

        return connection

    def get_columns(self):
        from psycopg2.extras import DictCursor
        cursor = self.connection.cursor(cursor_factory=DictCursor)
        cursor.execute("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = N'{}'".format(self.table_name))
        request_output = cursor.fetchall()
        columns = [column[3] for column in request_output]
        cursor.close()

        return columns

    def get_data(self):
        from psycopg2.extras import DictCursor
        cursor = self.connection.cursor(cursor_factory=DictCursor)
        cursor.execute("SELECT * FROM {}".format(self.table_name))
        request_output = cursor.fetchall()
        data_dict = {}
        for item in request_output:
            data_dict.setdefault(item[0], dict())
            i = 1
            for column in self.columns[1:]:
                data_dict[item[0]].update({column: item[i]})
                i += 1

        cursor.close()

        return data_dict


class TicketsUpdater(sdk2.Task):
    def on_execute(self):
        secrets = Secrets()

        courses_db = DataBase(secrets.db_password, "courses")
        tickets_db = DataBase(secrets.db_password, "tickets")
        employees_db = DataBase(secrets.db_password, "employees")

        tickets = Tickets(secrets, tickets_db, courses_db, employees_db)

        for ticket, params in tickets.tickets.items():
            if params["dismissed"]:
                tickets.close_ticket_dismissed(ticket)
            elif params["courses_passed"] and (params["tag"] == "compliance_repassing_courses" or params["tag"] == "compliance_courses"):
                tickets.close_ticket_courses(ticket)
