import sandbox.sdk2
import sandbox.sdk2.parameters


class CloudContractChecker(sandbox.sdk2.Task):
    class Parameters(sandbox.sdk2.Parameters):
        vault_startrek_token = sandbox.sdk2.parameters.String(required=True, label='Vault ID for Startrek token')
        vault_staff_token = sandbox.sdk2.parameters.String(required=True, label='Vault ID for Staff token')
        vault_owner = sandbox.sdk2.parameters.String(required=True, label='Vault owner')

        dry_run = sandbox.sdk2.parameters.Bool(default=True, label='Dry run')
        query = sandbox.sdk2.parameters.String(label='Startrek query')
        notify_during_business_hours = sandbox.sdk2.parameters.Bool(default=True, label='Only send notifications during business hours')

    def on_execute(self):
        from cloud.tools.contract_checker.contract_checker import DEFAULT_CONFIG, run
        from search.martylib.core.logging_utils import configure_basic_logging

        configure_basic_logging('sandbox', loggers={'contract_checker'})

        startrek_token = sandbox.sdk2.Vault.data(self.Parameters.vault_owner, self.Parameters.vault_startrek_token)
        staff_token = sandbox.sdk2.Vault.data(self.Parameters.vault_owner, self.Parameters.vault_staff_token)

        config = DEFAULT_CONFIG
        if self.Parameters.query:
            config.startrek_query = self.Parameters.query

        run(
            dry_run=self.Parameters.dry_run,
            config=config,
            startrek_token=startrek_token,
            staff_token=staff_token,
            sleep=False,
            notify_during_business_hours=self.Parameters.notify_during_business_hours,
        )
