from sandbox import sdk2
from sandbox.projects.common.juggler import jclient


class YcIamTask(sdk2.Task):
    INHERITED_REQS = ('ram', 'disk_space')

    class Parameters(sdk2.Task.Parameters):
        juggler_host = sdk2.parameters.String(
            'Host Name in Juggler',
            default='yc_iam_scheduled_sandbox_jobs',
            required=True
        )
        juggler_service_name = sdk2.parameters.String(
            'Service name in Juggler',
            default='',
            required=True
        )

    def on_failure(self, prev_status):
        super(YcIamTask, self).on_failure(prev_status)
        self.send_event_to_juggler('CRIT')

    def on_break(self, prev_status, status):
        super(YcIamTask, self).on_break(prev_status, status)
        self.send_event_to_juggler('CRIT')

    def send_event_to_juggler(self, status, host=None, service=None, description=None):
        host = host or self.Parameters.juggler_host
        service = service or self.Parameters.juggler_service_name
        if not host or not service:
            return
        task_link = 'https://sandbox.yandex-team.ru/task/%s/view' % self.id
        if status.upper() == 'OK':
            description = description or 'Scheduled Job OK. %s' % task_link
        else:
            description = description or 'Scheduled Job Failed. %s' % task_link
        jclient.send_events_to_juggler(
            host,
            service,
            status,
            description
        )
