#
# Not all YDB types could be transparently converted to YT types
# So we place here only convertible types
#
# Other types are described here: https://ydb.yandex-team.ru/docs/concepts/datatypes/
#

TYPE_MAP = {
    'INT64': 'int64',
    'INT32': 'int32',
    'INT16': 'int16',
    'INT8': 'int8',
    'UINT64': 'uint64',
    'UINT32': 'uint32',
    'UINT16': 'uint16',
    'UINT8': 'uint8',
    'DECIMAL': 'double',  # Is it correct?
    'FLOAT': 'double',
    'DOUBLE': 'double',
    'BOOL': 'boolean',
    'STRING': 'string',
    'UTF8': 'utf8',
}


def ydb_to_yt_type(type_name):
    res = TYPE_MAP.get(type_name)
    if res is None:
        raise Exception('Not supported YDB type')

    return res


def get_yt_scheme_from_ydb_scheme(ydb_scheme):
    yt_scheme = []

    for col in ydb_scheme["columns"]:
        yt_scheme.append({
            "name": col["name"],
            "type": ydb_to_yt_type(col["type"]["optional_type"]["item"]["type_id"]),
        })

    return yt_scheme
