import logging
import os.path


class CmntEnv:
    DEFAULT_YT_PROXY = 'hahn'

    ENV_TESTING = 'testing'
    ENV_ALPHA = 'alpha'
    ENV_PRODUCTION = 'production'

    _BACKUP_ENV = {
        ENV_TESTING: 'testing',
        ENV_ALPHA: 'alpha',
        ENV_PRODUCTION: 'prod'
    }

    _YDB_ENV = {
        ENV_TESTING: 'TESTING',
        ENV_ALPHA: 'ALPHA',
        ENV_PRODUCTION: 'PRODUCTION'
    }

    _YDB_ENDPOINT = {
        ENV_TESTING: 'ydb-ru-prestable.yandex.net:2135',
        ENV_ALPHA: 'ydb-ru-prestable.yandex.net:2135',
        ENV_PRODUCTION: 'ydb-eu.yandex.net:2135'
    }

    _YDB_DATABASE = {
        ENV_TESTING: '/ru-prestable/commentator/testing/cmnt',
        ENV_ALPHA: '/ru-prestable/commentator/alpha/cmnt',
        ENV_PRODUCTION: '/eu/commentator/production/cmnt'
    }

    @staticmethod
    def __get_by_env(env, env_dict):
        if env in env_dict:
            return env_dict[env]
        raise 'Unknown env ' + env

    @staticmethod
    def get_ydb_endpoint(env):
        return CmntEnv.__get_by_env(env, CmntEnv._YDB_ENDPOINT)

    @staticmethod
    def get_ydb_database(env):
        return CmntEnv.__get_by_env(env, CmntEnv._YDB_DATABASE)

    @staticmethod
    def get_backup_env(env):
        return CmntEnv.__get_by_env(env, CmntEnv._BACKUP_ENV)

    @staticmethod
    def get_ydb_env(env):
        return CmntEnv.__get_by_env(env, CmntEnv._YDB_ENV)

    @staticmethod
    def get_yt_backup_path(env, path):
        return CmntEnv.yt_abs_path(os.path.join(path, CmntEnv.get_backup_env(env)))

    @staticmethod
    def yt_abs_path(path):
        return '/' + os.path.normpath('/' + path)  # make path starting with //

    @staticmethod
    def make_yt_name(now):
        return now.strftime('%Y-%m-%dT%H:%M:%S')

    @staticmethod
    def remove_old_data(yt_client, yt_path, max_count, recursive):
        old_data_items = yt_client.list(CmntEnv.yt_abs_path(yt_path), absolute=True)
        old_data_items = sorted(old_data_items, reverse=True)
        to_remove = old_data_items[max_count:]
        for item in to_remove:
            logging.info('Remove old data %s' % item)
            yt_client.remove(item, recursive=recursive)
