from sandbox import sdk2


class FastCodesearchBinary(sdk2.Resource):
    releasable = True
    any_arch = False
    releasers = [
        'CODESEARCH',
        'robot-srch-releaser',
    ]
    auto_backup = True


class FastCodesearchController(FastCodesearchBinary):
    arcadia_build_path = "devtools/codesearch/fcs/daemons/controller"


class FastCodesearchIndexer(FastCodesearchBinary):
    arcadia_build_path = "devtools/codesearch/fcs/daemons/indexer"


class FastCodesearchSearcher(FastCodesearchBinary):
    arcadia_build_path = "devtools/codesearch/fcs/daemons/searcher"


class FastCodesearchCs(FastCodesearchBinary):
    arcadia_build_path = "devtools/codesearch/fcs/tools/cs"


class FastCodesearchEvlogdump(FastCodesearchBinary):
    arcadia_build_path = "devtools/codesearch/fcs/tools/evlogdump"


class FastCodesearchPackage(FastCodesearchBinary):
    arcadia_build_path = "devtools/codesearch/fcs/package"


class FastCodesearchUi(FastCodesearchBinary):
    arcadia_build_path = "devtools/codesearch/fast_ui/codesearch_fast_ui"
