from sandbox.projects import BuildDynamicModels
from sandbox.projects.common.search import settings as media_settings
from sandbox.projects.common.dynamic_models.compare import generate_diff_footer
from sandbox.projects.common.nanny import nanny

from sandbox.projects.collections import resources
from sandbox.sandboxsdk.parameters import SandboxSvnUrlParameter
from sandbox.sandboxsdk.parameters import SandboxBoolParameter


class ModelsUrlForProduction(SandboxSvnUrlParameter):
    """
        SVN URL of pruduction formulas
    """
    name = 'models_svn_url_production'
    description = 'production models svn url (get latest released if empty)'
    default_value = media_settings.CollectionsSettings.DYNAMIC_MODELS_SVN_PRODUCTION_TRUNK_URL
    required = False


class ModelsUrlForExperiment(SandboxSvnUrlParameter):
    """
        SVN URL of experimental formulas
    """
    name = 'models_svn_url_experiment'
    description = 'experiment models svn url (get latest if empty)'
    default_value = media_settings.CollectionsSettings.DYNAMIC_MODELS_SVN_EXPERIMENT_TRUNK_URL
    required = False


class CheckProductionModelsList(SandboxBoolParameter):
    name = 'check_production_models_list'
    description = 'Check that production models contain Hast, Wizard and fast models'
    default_value = False


class StrictFormulaIdChecks(SandboxBoolParameter):
    name = 'strict_check_formula_id'
    description = 'Checks that all formulas contain ID and throws exception if true.'
    default_value = False


class FailWithoutSlices(SandboxBoolParameter):
    name = 'fail_without_slices'
    description = 'Fail if formula without slices.'
    default_value = False


class BuildBoardsDynamicModelsArchive(BuildDynamicModels.BuildDynamicModels, nanny.ReleaseToNannyTask):
    """
        Downloads ranking formulas from svn repository
        and build archive from them using tools/archiver
    """

    type = 'COLLECTIONS_BOARDS_BUILD_DYNAMIC_MODELS'

    description = 'Dynamic models archive for boardssearch'

    archive_name = 'boardssearch_models.archive'

    resource_type = resources.CollectionsBoardsDynamicModelsArchive

    input_parameters = (
        BuildDynamicModels.ModelsForProduction,
        ModelsUrlForProduction,
        BuildDynamicModels.ModelsForExperiment,
        ModelsUrlForExperiment,
        CheckProductionModelsList,
        StrictFormulaIdChecks,
        FailWithoutSlices,
    )

    def get_resource_type(self):
        return 'COLLECTIONS_BOARDS_DYNAMIC_MODELS_ARCHIVE'

    def filter_models(self, files):
        return files

    @property
    def footer(self):
        return generate_diff_footer(self.ctx.get('diff'))


__Task__ = BuildBoardsDynamicModelsArchive
