from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as consts
import sandbox.projects.common.build.parameters as build_params
from sandbox.projects.common.nanny import nanny

import sandbox.projects.collections.resources as resources


class CollectionsBoardsBuildRtyServerBinaries(BaseMediaBuildTask, nanny.ReleaseToNannyTask):
    """
       Binaries and configs for RTY server of boards search
    """

    type = 'COLLECTIONS_BOARDS_BUILD_RTY_SERVER_BINARIES'

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx[build_params.StripBinaries.name] = True

    def get_binaries(self):
        return (
            resources.CollectionsBoardsRtyServer
        )

    def get_configs(self):
        return (
            resources.CollectionsBoardsRtyServerConfigs
        )

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        BaseMediaBuildTask.on_release(self, additional_parameters)


__Task__ = CollectionsBoardsBuildRtyServerBinaries
