import logging

from sandbox import sdk2
import sandbox.sandboxsdk.copy as sdk_copy

import sandbox.projects.collections.resources as resources


BUNDLE_FILES = {
    "advert.vw": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/collections/boards_search/indexer/advert_classifier_vw_model",
}


class CollectionsBuildBoardsSearchIndexerBundle(sdk2.Task):
    """
        Generate configs and data for boards search indxer
    """
    class Requirements(sdk2.Task.Requirements):
        pass

    def on_execute(self):
        logging.info('Get resource object')
        resource = resources.CollectionsBoardsSearchIndexerBundle(self, "bundle files", "configs")
        resource_data = sdk2.ResourceData(resource)
        resource_data.path.mkdir()

        for filename, src_path in BUNDLE_FILES.iteritems():
            sdk_copy.RemoteCopy(src_path, str(resource_data.path.joinpath(filename)),
                                       log_dir=self.log_path())(timeout=sdk_copy.RemoteCopy.DEFAULT_TIMEOUT)
