# coding: utf-8

"""
    Подготовка py virtual environment, исполняемых скриптов и данных для PDB-DP сервера
"""

import os

from sandbox import sandboxsdk
from sandbox import sdk2

import sandbox.projects.resource_types.releasers as resource_releasers


class YasapPdbDPData(sdk2.Resource):
    """
        PDB-DP production data.
    """
    releasers = resource_releasers.collections_releasers
    releasable = True
    any_arch = True


class BuildYasapPdbDPData(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        svn_url = sdk2.parameters.String('SVN url', required=True, default=sandboxsdk.svn.Arcadia.trunk_url()+'/yweb/yasap/pdb/quality/dp/scripts')
        svn_revision = sdk2.parameters.Integer("SVN revision", required=True, default=-1)
        resource_path = "pdb-dp.data.tar.gz"

    def on_execute(self):
        sandboxsdk.paths.make_folder('scripts', delete_content=True)
        sandboxsdk.svn.Arcadia.export(url=self.Parameters.svn_url, path=os.path.join(os.getcwd(), "scripts"), revision=self.Parameters.svn_revision)

        with sandboxsdk.environments.VirtualEnvironment() as venv:
            sandboxsdk.paths.copy_path(os.path.join(os.getcwd(), "scripts"), os.path.join(venv.root_dir, "scripts"))
            venv.PYPI_URL = "https://pypi.yandex-team.ru/simple/"
            venv.pip("-U pip")
            venv.pip("-r {}".format(os.path.join(venv.root_dir, "scripts", "requirements.txt")))
            os.unlink(os.path.join(venv.root_dir, 'bin', 'activate'))
            venv.pack_bundle(self.Parameters.resource_path)
        sdk2.ResourceData(YasapPdbDPData(self, self.Parameters.description, self.Parameters.resource_path)).ready()
