# -*- coding: utf-8 -*-

from sandbox.projects.collections.informers import resource_types
from sandbox.projects.common.BaseBinariesAndConfigsTask import BaseBinariesAndConfigsTask
from sandbox.projects.common.nanny import nanny


class CollectionsInformersBuildRuntimeBundle(BaseBinariesAndConfigsTask, nanny.ReleaseToNannyTask):
    """
        Build informers runtime for all architectures and its configuration file
        Intended for making releases
    """

    type = 'COLLECTIONS_INFORMERS_BUILD_RUNTIME_BUNDLE'

    TARGET_RESOURCE_TYPES = (
        resource_types.CollectionsInformers,
    )

    TARGET_CONFIG_TYPES = (
        resource_types.CollectionsInformersConfig,
    )

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        BaseBinariesAndConfigsTask.on_release(self, additional_parameters)

__Task__ = CollectionsInformersBuildRuntimeBundle
